/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest.converter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.bo.NetworkPoint;
import org.restcomm.sbc.bo.NetworkPointList;
import org.restcomm.sbc.rest.converter.AbstractConverter;

@ThreadSafe
public final class NetworkPointListConverter
extends AbstractConverter
implements JsonSerializer<NetworkPointList> {
    public NetworkPointListConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return NetworkPointList.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        NetworkPointList list = (NetworkPointList)object;
        writer.startNode("NetworkPoints");
        for (NetworkPoint point : list.getNetworkPointList()) {
            context.convertAnother((Object)point);
        }
        writer.endNode();
    }

    public JsonObject serialize(NetworkPointList pointList, Type type, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        JsonArray array = new JsonArray();
        for (NetworkPoint point : pointList.getNetworkPointList()) {
            array.add(context.serialize((Object)point));
        }
        result.add("entries", (JsonElement)array);
        return result;
    }
}

