/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.chain.processor.impl;

import org.apache.log4j.Logger;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.Processor;
import org.restcomm.chain.processor.impl.DefaultProcessor;
import org.restcomm.chain.processor.impl.MutableMessage;
import org.restcomm.chain.processor.impl.ProcessorParsingException;

public abstract class DefaultDPIProcessor
extends DefaultProcessor {
    private static transient Logger LOG = Logger.getLogger(DefaultDPIProcessor.class);

    public DefaultDPIProcessor() {
        this.type = Processor.Type.CHAIN;
    }

    public DefaultDPIProcessor(String name) {
        super(name);
        this.type = Processor.Type.CHAIN;
    }

    public DefaultDPIProcessor(ProcessorChain chain) {
        super(chain);
        this.type = Processor.Type.SINGLE_PROCESSOR;
    }

    public DefaultDPIProcessor(String name, ProcessorChain chain) {
        super(name, chain);
    }

    public void process(MutableMessage message) throws ProcessorParsingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">> process() message [" + message + "]"));
        }
        MutableMessage immutableMessage = message;
        this.fireProcessingEvent((Message)immutableMessage, (Processor)this.getCallback());
        this.getCallback().doProcess((Message)immutableMessage);
        this.fireEndEvent((Message)immutableMessage, (Processor)this.getCallback());
        Processor nextLink = null;
        if (this.chain != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DPI " + this.type + " from callback " + ((Processor)this.getCallback()).getName() + " chain " + this.chain.getName()));
            }
            nextLink = this.chain.getNextLink((Processor)this);
        }
        if (nextLink != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DPI " + this.type + " from callback " + ((Processor)this.getCallback()).getName() + " nextlink " + nextLink.getName()));
            }
            nextLink.process(message);
        }
    }
}

