/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.adapter;

import java.io.IOException;
import java.net.NoRouteToHostException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletResponse;
import org.apache.log4j.Logger;
import org.mobicents.media.server.io.sdp.SdpException;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.managers.ProtocolAdapterFactory;
import org.restcomm.sbc.media.MediaController;
import org.restcomm.sbc.media.MediaSession;

public abstract class ProtocolAdapter {
    private static transient Logger LOG = Logger.getLogger(ProtocolAdapter.class);

    public abstract Message adapt(Message var1) throws NoRouteToHostException;

    public abstract String getProtocol();

    public Message adaptMedia(Message message) {
        SIPMutableMessage m = (SIPMutableMessage)message;
        SipServletMessage sm = m.getContent();
        if (sm.getContentLength() > 0 && sm.getContentType().equalsIgnoreCase("application/sdp")) {
            try {
                MediaController mediaController;
                MediaSession mediaSession;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(sm.getMethod() + " adapting SDP"));
                }
                String host = message.getTargetLocalAddress();
                if (sm instanceof SipServletResponse) {
                    mediaSession = (MediaSession)m.getMetadata();
                    mediaController = mediaSession.getAnswer();
                    mediaSession.attach();
                    mediaController.setLocalProxy(host);
                } else {
                    mediaSession = (MediaSession)m.getMetadata();
                    mediaController = mediaSession.getOffer();
                    mediaController.setLocalProxy(host);
                }
                String sdpContent = mediaController.getProxySdp(host);
                if (m.getTarget() == 1) {
                    if (ConfigurationCache.isMediaDecodingEnabled()) {
                        sdpContent = mediaController.getUnsecureProxySdp(host);
                    }
                } else if (this.getProtocol().equals(ProtocolAdapterFactory.PROTOCOL_WSS) && !mediaController.isOffer()) {
                    sdpContent = mediaController.getSecureProxySdp(host);
                }
                m.setMetadata((Object)mediaSession);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("MDA " + m.getMetadata()));
                    LOG.debug((Object)m.toString());
                    LOG.debug((Object)("patched Content:\n" + sdpContent));
                }
                sm.setContent((Object)sdpContent, "application/sdp");
                m.setContent((Object)sm);
            }
            catch (IOException e) {
                LOG.error((Object)"No SDP content!", (Throwable)e);
                return m;
            }
            catch (SdpException e) {
                LOG.error((Object)"MediaMetadata invalid!", (Throwable)e);
                return m;
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(sm.getMethod() + " without SDP"));
        }
        return m;
    }
}

