/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.bo.shiro;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.Permission;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.authz.SimpleRole;
import org.apache.shiro.authz.permission.DomainPermission;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.bo.Account;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.bo.shiro.ShiroResources;
import org.restcomm.sbc.dao.AccountsDao;
import org.restcomm.sbc.dao.DaoManager;

@ThreadSafe
public final class Realm
extends AuthorizingRealm {
    private volatile Map<String, SimpleRole> roles;

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        Sid sid = new Sid((String)principals.getPrimaryPrincipal());
        ShiroResources services = ShiroResources.getInstance();
        DaoManager daos = (DaoManager)services.get(DaoManager.class);
        AccountsDao accounts = daos.getAccountsDao();
        Account account = accounts.getAccount(sid);
        String roleName = account.getRole();
        HashSet<String> set = new HashSet<String>();
        set.add(roleName);
        SimpleAuthorizationInfo authorizationInfo = new SimpleAuthorizationInfo(set);
        SimpleRole role = this.getRole(roleName);
        if (role != null) {
            authorizationInfo.setObjectPermissions(role.getPermissions());
        }
        return authorizationInfo;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws AuthenticationException {
        UsernamePasswordToken authenticationToken = (UsernamePasswordToken)token;
        String username = authenticationToken.getUsername();
        Sid sid = null;
        Account account = null;
        String authToken = null;
        ShiroResources services = ShiroResources.getInstance();
        DaoManager daos = (DaoManager)services.get(DaoManager.class);
        AccountsDao accounts = daos.getAccountsDao();
        try {
            if (Sid.pattern.matcher(username).matches()) {
                sid = new Sid(username);
                account = accounts.getAccount(sid);
            } else {
                account = accounts.getAccount(username);
                sid = account.getSid();
            }
            if (account != null) {
                authToken = account.getAuthToken();
                return new SimpleAuthenticationInfo((Object)sid.toString(), (Object)authToken.toCharArray(), this.getName());
            }
            return null;
        }
        catch (Exception ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleRole getRole(String role) {
        if (this.roles != null) {
            return (SimpleRole)this.roles.get(role);
        }
        Realm realm = this;
        synchronized (realm) {
            if (this.roles == null) {
                this.roles = new HashMap();
                ShiroResources services = ShiroResources.getInstance();
                Configuration configuration = (Configuration)services.get(Configuration.class);
                this.loadSecurityRoles(configuration.subset("security-roles"));
            }
        }
        return (SimpleRole)this.roles.get(role);
    }

    private void loadSecurityRoles(Configuration configuration) {
        List roleNames = configuration.getList("role[@name]");
        int numberOfRoles = roleNames.size();
        if (numberOfRoles > 0) {
            for (int roleIndex = 0; roleIndex < numberOfRoles; ++roleIndex) {
                StringBuilder buffer = new StringBuilder();
                buffer.append("role(").append(roleIndex).append(")").toString();
                String prefix = buffer.toString();
                String name = configuration.getString(prefix + "[@name]");
                List permissions = configuration.getList(prefix + ".permission");
                int numberOfPermissions = permissions.size();
                if (name == null || numberOfPermissions <= 0) continue;
                SimpleRole role = new SimpleRole(name);
                for (int permissionIndex = 0; permissionIndex < numberOfPermissions; ++permissionIndex) {
                    buffer = new StringBuilder();
                    buffer.append(prefix).append(".permission(").append(permissionIndex).append(")");
                    DomainPermission permission = new DomainPermission(buffer.toString());
                    role.add((Permission)permission);
                }
                this.roles.put(name, role);
            }
        }
    }
}

