/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.chain.impl.invite;

import java.io.IOException;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.apache.log4j.Logger;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.ProcessorCallBack;
import org.restcomm.chain.processor.impl.DefaultDPIProcessor;
import org.restcomm.chain.processor.impl.ProcessorParsingException;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.managers.RouteManager;

public class InviteDPIProcessor
extends DefaultDPIProcessor
implements ProcessorCallBack {
    private static transient Logger LOG = Logger.getLogger(InviteDPIProcessor.class);
    private String name = "INVITE DPI Processor";

    public InviteDPIProcessor(ProcessorChain chain) {
        super(chain);
        this.chain = chain;
    }

    public InviteDPIProcessor(String name, ProcessorChain chain) {
        this(chain);
        this.setName(name);
    }

    private void processInviteRequest(SIPMutableMessage message) {
        SipServletRequest request = (SipServletRequest)message.getContent();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("INVITE REQUEST DMZ:" + RouteManager.isFromDMZ((SipServletMessage)request)));
            LOG.trace((Object)("From/To " + request.getFrom() + "/" + request.getTo()));
        }
    }

    private void processInviteResponse(SIPMutableMessage message) {
        SipServletResponse response = (SipServletResponse)message.getContent();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("INVITE RESPONSE DMZ:" + RouteManager.isFromDMZ((SipServletMessage)response)));
            LOG.trace((Object)("From/To " + response.getFrom() + "/" + response.getTo()));
        }
        if (response.getStatus() == 200) {
            SipServletRequest ackRequest = response.createAck();
            try {
                ackRequest.send();
            }
            catch (IOException e) {
                LOG.error((Object)"Cannot send ACK!", (Throwable)e);
            }
        }
    }

    private void processByeRequest(SIPMutableMessage message) {
        SipServletRequest request = (SipServletRequest)message.getContent();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Got Request BYE: " + request.getMethod()));
        }
    }

    private void processAckRequest(SIPMutableMessage message) {
    }

    private void processPrackRequest(SIPMutableMessage message) {
        SipServletRequest request = (SipServletRequest)message.getContent();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Got Request PRACK: " + request.getMethod() + " State:" + request.getSession().getState().toString()));
        }
        SipServletResponse ok = request.createResponse(200);
        try {
            ok.send();
        }
        catch (IOException e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    private void processInfoRequest(SIPMutableMessage message) {
    }

    private void processCancelRequest(SIPMutableMessage message) {
        SipServletRequest request = (SipServletRequest)message.getContent();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Got Request CANCEL: " + request.getMethod() + " State:" + request.getSession().getState().toString()));
        }
        SipServletResponse ok = request.createResponse(200);
        SipServletResponse terminated = request.createResponse(487);
        try {
            ok.send();
            terminated.send();
        }
        catch (IOException e) {
            LOG.error((Object)"", (Throwable)e);
        }
    }

    private void processByeResponse(SIPMutableMessage message) {
        SipServletResponse response = (SipServletResponse)message.getContent();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Got Response BYE: " + response.getMethod()));
        }
    }

    private void processInfoResponse(SIPMutableMessage message) {
        SipServletResponse response = (SipServletResponse)message.getContent();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Got Response INFO: " + response.getMethod()));
        }
    }

    private void processCancelResponse(SIPMutableMessage message) {
        SipServletResponse response = (SipServletResponse)message.getContent();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Got Response CANCEL: " + response.getMethod()));
        }
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.hashCode();
    }

    public void setName(String name) {
        this.name = name;
    }

    public ProcessorCallBack getCallback() {
        return this;
    }

    public void doProcess(Message message) throws ProcessorParsingException {
        SIPMutableMessage m = (SIPMutableMessage)message;
        SipServletMessage sm = m.getContent();
        m.setSourceLocalAddress(sm.getLocalAddr());
        m.setSourceRemoteAddress(sm.getRemoteAddr());
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> doProcess()");
        }
        if (sm instanceof SipServletRequest) {
            if (sm.getMethod().equals("INVITE")) {
                this.processInviteRequest(m);
            } else if (sm.getMethod().equals("BYE")) {
                this.processByeRequest(m);
            } else if (sm.getMethod().equals("ACK")) {
                this.processAckRequest(m);
            } else if (sm.getMethod().equals("PRACK")) {
                this.processPrackRequest(m);
            } else if (sm.getMethod().equals("CANCEL")) {
                this.processCancelRequest(m);
            } else if (sm.getMethod().equals("INFO")) {
                this.processInfoRequest(m);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request METHOD " + sm.getMethod() + " not supported!"));
            }
        }
        if (sm instanceof SipServletResponse) {
            if (sm.getMethod().equals("INVITE")) {
                this.processInviteResponse(m);
            } else if (sm.getMethod().equals("BYE")) {
                this.processByeResponse(m);
            } else if (sm.getMethod().equals("CANCEL")) {
                this.processCancelResponse(m);
            } else if (sm.getMethod().equals("INFO")) {
                this.processInfoResponse(m);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Response METHOD " + sm.getMethod() + " not supported!"));
            }
        }
    }

    public String getVersion() {
        return "1.0.0";
    }
}

