/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.configuration.sets;

import org.apache.commons.lang.StringUtils;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.Immutable;
import org.restcomm.sbc.configuration.sets.ConfigurationSet;
import org.restcomm.sbc.configuration.sets.SslMode;
import org.restcomm.sbc.configuration.sources.ConfigurationSource;

@Immutable
public class MainConfigurationSet
extends ConfigurationSet {
    private static final String SSL_MODE_KEY = "http-client.ssl-mode";
    private static final String HTTP_RESPONSE_TIMEOUT = "http-client.response-timeout";
    private static final SslMode SSL_MODE_DEFAULT = SslMode.strict;
    private final SslMode sslMode;
    private final int responseTimeout;
    private static final String USE_HOSTNAME_TO_RESOLVE_RELATIVE_URL_KEY = "http-client.use-hostname-to-resolve-relative-url";
    private static final boolean RESOLVE_RELATIVE_URL_WITH_HOSTNAME_DEFAULT = true;
    private final boolean useHostnameToResolveRelativeUrls;
    private final String hostname;
    private String instanceId;
    public static final String BYPASS_LB_FOR_CLIENTS = "bypass-lb-for-clients";
    private boolean bypassLbForClients = false;

    public MainConfigurationSet(ConfigurationSource source) {
        super(source);
        String resolveRelativeUrlHostname;
        boolean resolveRelativeUrlWithHostname;
        SslMode sslMode;
        boolean bypassLb = false;
        int timeout = 5000;
        try {
            timeout = Integer.parseInt(source.getProperty(HTTP_RESPONSE_TIMEOUT));
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing 'http-client.response-timeout' configuration setting", e);
        }
        try {
            sslMode = SSL_MODE_DEFAULT;
            String sslModeRaw = source.getProperty(SSL_MODE_KEY);
            if (!StringUtils.isEmpty((String)sslModeRaw)) {
                sslMode = SslMode.valueOf((String)sslModeRaw);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing 'http-client.ssl-mode' configuration setting", e);
        }
        this.sslMode = sslMode;
        try {
            resolveRelativeUrlWithHostname = true;
            resolveRelativeUrlWithHostname = Boolean.valueOf(source.getProperty(USE_HOSTNAME_TO_RESOLVE_RELATIVE_URL_KEY));
            resolveRelativeUrlHostname = source.getProperty("http-client.hostname");
            bypassLb = Boolean.valueOf(source.getProperty(BYPASS_LB_FOR_CLIENTS));
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing 'http-client.use-hostname-to-resolve-relative-url' configuration setting", e);
        }
        this.responseTimeout = timeout;
        this.useHostnameToResolveRelativeUrls = resolveRelativeUrlWithHostname;
        this.hostname = resolveRelativeUrlHostname;
        this.bypassLbForClients = bypassLb;
    }

    public SslMode getSslMode() {
        return this.sslMode;
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    public boolean isUseHostnameToResolveRelativeUrls() {
        return this.useHostnameToResolveRelativeUrls;
    }

    public String getHostname() {
        return this.hostname;
    }

    public boolean getBypassLbForClients() {
        return this.bypassLbForClients;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }
}

