/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.dao.mybatis;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.bo.Account;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.dao.AccountsDao;
import org.restcomm.sbc.dao.DaoUtils;

@ThreadSafe
public final class MybatisAccountsDao
implements AccountsDao {
    private static final String namespace = "org.restcomm.sbc.dao.AccountsDao.";
    private final SqlSessionFactory sessions;

    public MybatisAccountsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccount(Account account) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.restcomm.sbc.dao.AccountsDao.addAccount", (Object)this.toMap(account));
            session.commit();
        }
    }

    public Account getAccount(Sid sid) {
        return this.getAccount("org.restcomm.sbc.dao.AccountsDao.getAccount", (Object)sid.toString());
    }

    public Account getAccount(String name) {
        Account account = null;
        account = this.getAccount("org.restcomm.sbc.dao.AccountsDao.getAccountByEmail", (Object)name);
        if (account == null) {
            account = this.getAccount("org.restcomm.sbc.dao.AccountsDao.getAccountByFriendlyName", (Object)name);
        }
        if (account == null) {
            account = this.getAccount("org.restcomm.sbc.dao.AccountsDao.getAccount", (Object)name);
        }
        return account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Account getAccount(String selector, Object parameters) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne(selector, parameters);
            if (result != null) {
                Account account = this.toAccount(result);
                return account;
            }
            Account account = null;
            return account;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Account> getAccounts(Sid accountSid) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.restcomm.sbc.dao.AccountsDao.getAccounts", (Object)accountSid.toString());
            ArrayList<Account> accounts = new ArrayList<Account>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    accounts.add(this.toAccount(result));
                }
            }
            ArrayList<Account> arrayList = accounts;
            return arrayList;
        }
    }

    public void removeAccount(Sid sid) {
        this.removeAccount("org.restcomm.sbc.dao.AccountsDao.removeAccount", sid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAccount(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, (Object)sid.toString());
            session.commit();
        }
    }

    public void updateAccount(Account account) {
        this.updateAccount("org.restcomm.sbc.dao.AccountsDao.updateAccount", account);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAccount(String selector, Account account) {
        try (SqlSession session = this.sessions.openSession();){
            session.update(selector, (Object)this.toMap(account));
            session.commit();
        }
    }

    private Account toAccount(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid((Object)map.get("sid"));
        DateTime dateCreated = DaoUtils.readDateTime((Object)map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime((Object)map.get("date_updated"));
        String emailAddress = DaoUtils.readString((Object)map.get("email_address"));
        String friendlyName = DaoUtils.readString((Object)map.get("friendly_name"));
        Sid accountSid = DaoUtils.readSid((Object)map.get("account_sid"));
        Account.Type type = DaoUtils.readAccountType((Object)map.get("type"));
        Account.Status status = DaoUtils.readAccountStatus((Object)map.get("status"));
        String authToken = DaoUtils.readString((Object)map.get("auth_token"));
        String role = DaoUtils.readString((Object)map.get("role"));
        URI uri = DaoUtils.readUri((Object)map.get("uri"));
        return new Account(sid, dateCreated, dateUpdated, emailAddress, friendlyName, accountSid, type, status, authToken, role, uri);
    }

    public Account getAccountToAuthenticate(String name) {
        Account account = null;
        account = this.getAccount("org.restcomm.sbc.dao.AccountsDao.getAccountByEmail", (Object)name);
        if (account == null) {
            account = this.getAccount("org.restcomm.sbc.dao.AccountsDao.getAccount", (Object)name);
        }
        return account;
    }

    private Map<String, Object> toMap(Account account) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid((Sid)account.getSid()));
        map.put("date_created", DaoUtils.writeDateTime((DateTime)account.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime((DateTime)account.getDateUpdated()));
        map.put("email_address", account.getEmailAddress());
        map.put("friendly_name", account.getFriendlyName());
        map.put("account_sid", DaoUtils.writeSid((Sid)account.getAccountSid()));
        map.put("type", DaoUtils.writeAccountType((Account.Type)account.getType()));
        map.put("status", DaoUtils.writeAccountStatus((Account.Status)account.getStatus()));
        map.put("auth_token", account.getAuthToken());
        map.put("role", account.getRole());
        map.put("uri", DaoUtils.writeUri((URI)account.getUri()));
        return map;
    }
}

