/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.identity;

import org.apache.commons.codec.digest.DigestUtils;
import org.restcomm.sbc.bo.Account;
import org.restcomm.sbc.dao.AccountsDao;

public class AccountKey {
    private String challengedSid;
    private String challengedKey;
    private Account account;
    private boolean verified = false;

    public AccountKey(String sid, String key, AccountsDao dao) {
        this.challengedSid = sid;
        this.challengedKey = key;
        this.account = dao.getAccountToAuthenticate(sid);
        this.verify(dao);
    }

    private void verify(AccountsDao dao) {
        if (this.account != null && this.challengedKey != null && (this.challengedKey.equals(this.account.getAuthToken()) || DigestUtils.md5Hex((String)this.challengedKey).equals(this.account.getAuthToken()))) {
            this.verified = true;
        }
    }

    public Account getAccount() {
        return this.account;
    }

    public boolean isVerified() {
        return this.verified;
    }
}

