/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media.dtls;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.security.SecureRandom;
import org.bouncycastle.crypto.tls.DTLSServerProtocol;
import org.bouncycastle.crypto.tls.DTLSTransport;
import org.bouncycastle.crypto.tls.DatagramTransport;
import org.bouncycastle.crypto.tls.TlsServer;
import org.bouncycastle.crypto.tls.UDPTransport;
import org.restcomm.sbc.media.dtls.DtlsConfiguration;
import org.restcomm.sbc.media.dtls.DtlsSrtpServer;
import org.restcomm.sbc.media.dtls.DtlsSrtpServerProvider;

public class DtlsServerHandler {
    DTLSServerProtocol serverProtocol;
    DtlsSrtpServer server;
    DatagramTransport transport;
    DatagramSocket socket;

    public DtlsServerHandler() {
        SecureRandom secureRandom = new SecureRandom();
        this.serverProtocol = new DTLSServerProtocol(secureRandom);
        DtlsConfiguration configuration = new DtlsConfiguration();
        DtlsSrtpServerProvider dtlsServerProvider = null;
        dtlsServerProvider = new DtlsSrtpServerProvider(configuration.getMinVersion(), configuration.getMaxVersion(), configuration.getCipherSuites(), configuration.getCertificatePath(), configuration.getKeyPath(), configuration.getAlgorithmCertificate());
        this.server = dtlsServerProvider.provide();
    }

    public void handshake(DatagramSocket socket) throws IOException {
        int mtu = 1500;
        byte[] data = new byte[mtu];
        DatagramPacket packet = new DatagramPacket(data, mtu);
        socket.receive(packet);
        System.out.println("Accepting connection from " + packet.getAddress().getHostAddress() + ":" + socket.getPort());
        socket.connect(packet.getAddress(), packet.getPort());
        this.transport = new UDPTransport(socket, mtu);
        DTLSTransport dtlsServer = this.serverProtocol.accept((TlsServer)this.server, this.transport);
        this.server.prepareSrtpSharedSecret();
    }
}

