/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.io.IOException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.NotThreadSafe;
import org.restcomm.sbc.bo.Account;
import org.restcomm.sbc.bo.Connector;
import org.restcomm.sbc.bo.ConnectorList;
import org.restcomm.sbc.bo.NetworkPoint;
import org.restcomm.sbc.bo.RestCommResponse;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.configuration.RestcommConfiguration;
import org.restcomm.sbc.dao.AccountsDao;
import org.restcomm.sbc.dao.ConnectorsDao;
import org.restcomm.sbc.dao.DaoManager;
import org.restcomm.sbc.dao.NetworkPointsDao;
import org.restcomm.sbc.managers.NetworkManager;
import org.restcomm.sbc.managers.jmx.JMXProvider;
import org.restcomm.sbc.managers.jmx.JMXProviderFactory;
import org.restcomm.sbc.rest.ConnectorsEndpoint;
import org.restcomm.sbc.rest.SecuredEndpoint;
import org.restcomm.sbc.rest.converter.ConnectorConverter;
import org.restcomm.sbc.rest.converter.ConnectorListConverter;
import org.restcomm.sbc.rest.converter.RestCommResponseConverter;

@NotThreadSafe
public abstract class ConnectorsEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected DaoManager daos;
    protected Gson gson;
    protected GsonBuilder builder;
    protected XStream xstream;
    protected AccountsDao accountsDao;
    protected String instanceId;
    protected ConnectorListConverter listConverter;
    protected JMXProvider jmxManager;
    private static transient Logger LOG = Logger.getLogger(ConnectorsEndpoint.class);

    @PostConstruct
    public void init() {
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        this.daos = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.accountsDao = this.daos.getAccountsDao();
        super.init(this.configuration);
        this.listConverter = new ConnectorListConverter(this.configuration);
        ConnectorConverter converter = new ConnectorConverter(this.configuration);
        this.builder = new GsonBuilder();
        this.builder.registerTypeAdapter(Connector.class, (Object)converter);
        this.builder.registerTypeAdapter(ConnectorList.class, (Object)this.listConverter);
        this.builder.setPrettyPrinting();
        this.gson = this.builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.xstream.registerConverter((Converter)this.listConverter);
        this.instanceId = RestcommConfiguration.getInstance().getMain().getInstanceId();
        try {
            this.jmxManager = JMXProviderFactory.getJMXProvider();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.error((Object)"JMX Error", (Throwable)e);
        }
    }

    protected Response getConnector(Sid sid, MediaType responseType) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Read:Connectors");
        ConnectorsDao dao = this.daos.getConnectorsDao();
        Connector connector = dao.getConnector(sid);
        if (connector == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(account, account.getSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)connector);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)connector), (String)"application/json").build();
        }
        return null;
    }

    protected Response getConnectorsByNetworkPoint(String pointId, MediaType responseType) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Read:Connectors");
        ConnectorsDao dao = this.daos.getConnectorsDao();
        List connectors = dao.getConnectorsByNetworkPoint(pointId);
        if (connectors == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(account, account.getSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new ConnectorList(connectors));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)new ConnectorList(connectors)), (String)"application/json").build();
        }
        return null;
    }

    protected Response deleteConnector(Sid sid) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Delete:Connectors", SecuredEndpoint.SecuredType.SECURED_ACCOUNT);
        ConnectorsDao dao = this.daos.getConnectorsDao();
        Connector connector = dao.getConnector(sid);
        if (connector == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        NetworkPoint point = NetworkManager.getNetworkPoint((String)connector.getPoint());
        boolean status = false;
        if (point != null) {
            try {
                status = this.jmxManager.removeSipConnector(point.getAddress().getHostAddress(), connector.getPort(), connector.getTransport().toString());
            }
            catch (IOException | InstanceNotFoundException | MBeanException | ReflectionException e) {
                LOG.error((Object)"JMX Manager failed");
            }
        }
        if (!status) {
            LOG.error((Object)"SIP Connector was not unbound");
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"Cannot unbind SIP Connector").build();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Unbinding SIP Connector on " + point.getDescription() + " " + point.getAddress().getHostAddress() + ":" + connector.getPort() + "/" + connector.getTransport().toString()));
        }
        dao.removeConnector(sid);
        return Response.ok().build();
    }

    protected Response getConnectors(UriInfo info, MediaType responseType) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Read:Connectors");
        ConnectorsDao dao = this.daos.getConnectorsDao();
        List connectors = dao.getConnectors();
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new ConnectorList(connectors));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)new ConnectorList(connectors)), (String)"application/json").build();
        }
        return null;
    }

    private Connector createFrom(String accountSid, MultivaluedMap<String, String> data) {
        Connector.Builder builder = Connector.builder();
        int port = Integer.parseInt((String)data.getFirst((Object)"Port"));
        builder.setPort(port);
        builder.setAccountSid(new Sid(accountSid));
        String transport = (String)data.getFirst((Object)"Transport");
        builder.setTransport(Connector.Transport.valueOf((String)transport));
        String point = (String)data.getFirst((Object)"NetworkPointId");
        builder.setPoint(point);
        builder.setState(Connector.State.DOWN);
        Sid sid = Sid.generate((Sid.Type)Sid.Type.CONNECTOR, (String)(point + ":" + port + ":" + transport));
        builder.setSid(sid);
        return builder.build();
    }

    protected Response putConnector(MultivaluedMap<String, String> data, MediaType responseType) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Modify:Connectors");
        ConnectorsDao dao = this.daos.getConnectorsDao();
        try {
            this.validate(data);
        }
        catch (RuntimeException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        Connector connector = this.createFrom(account.getSid().toString(), data);
        String ipAddress = NetworkManager.getIpAddress((String)connector.getPoint());
        boolean status = false;
        if (ipAddress != null) {
            try {
                status = this.jmxManager.addSipConnector(ipAddress, connector.getPort(), connector.getTransport().toString());
            }
            catch (IOException | InstanceNotFoundException | MBeanException | ReflectionException e) {
                LOG.error((Object)"JMX Manager failed");
            }
        }
        if (!status) {
            LOG.error((Object)"SIP Connector was not unbound");
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"Cannot bind SIP Connector").build();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Binding SIP Connector on " + connector.getPoint() + " " + ipAddress + ":" + connector.getPort() + "/" + connector.getTransport().toString()));
        }
        dao.addConnector(connector);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)connector);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)connector), (String)"application/json").build();
        }
        return null;
    }

    protected Response updateConnector(Sid sid, MultivaluedMap<String, String> data, MediaType responseType) {
        NetworkPoint point;
        boolean status = false;
        Connector.State state = null;
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Delete:Connectors", SecuredEndpoint.SecuredType.SECURED_ACCOUNT);
        ConnectorsDao dao = this.daos.getConnectorsDao();
        Connector connector = dao.getConnector(sid);
        if (connector == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Cannot find Connector!").build();
        }
        if (data.containsKey((Object)"State")) {
            state = Connector.State.getValueOf((String)((String)data.getFirst((Object)"State")).toUpperCase());
            connector.setState(state);
        }
        if ((point = NetworkManager.getNetworkPoint((String)connector.getPoint())) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Cannot find NetworkPoint!").build();
        }
        switch (1.$SwitchMap$org$restcomm$sbc$bo$Connector$State[state.ordinal()]) {
            case 1: {
                try {
                    status = this.jmxManager.addSipConnector(point.getAddress().getHostAddress(), connector.getPort(), connector.getTransport().toString());
                }
                catch (IOException | InstanceNotFoundException | MBeanException | ReflectionException e) {
                    LOG.error((Object)"JMX Manager failed");
                }
                break;
            }
            case 2: {
                try {
                    status = this.jmxManager.removeSipConnector(point.getAddress().getHostAddress(), connector.getPort(), connector.getTransport().toString());
                }
                catch (IOException | InstanceNotFoundException | MBeanException | ReflectionException e) {
                    LOG.error((Object)"JMX Manager failed");
                }
                break;
            }
            default: {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Unknown State").build();
            }
        }
        if (!status) {
            LOG.debug((Object)("SIP Connector was not rebound! " + point.getId() + " " + point.getAddress().getHostAddress() + ":" + connector.getPort() + "/" + connector.getTransport().toString()));
            return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"Cannot rebind SIP Connector").build();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Rebinding SIP Connector on " + point.getId() + " " + point.getAddress().getHostAddress() + ":" + connector.getPort() + "/" + connector.getTransport().toString()));
        }
        dao.updateConnector(sid, state.toString());
        return Response.ok().build();
    }

    private void validate(MultivaluedMap<String, String> data) {
        NetworkPointsDao dao = this.daos.getNetworkPointDao();
        if (!data.containsKey((Object)"Port")) {
            throw new NullPointerException("Port cannot be null.");
        }
        if (!data.containsKey((Object)"Transport")) {
            throw new NullPointerException("Transport cannot be null.");
        }
        String id = (String)data.getFirst((Object)"NetworkPointId");
        if (!NetworkManager.exists((String)id)) {
            throw new NullPointerException("Real NetworkPointId does not exist.");
        }
        NetworkPoint point = dao.getNetworkPoint(id);
        if (point == null) {
            throw new NullPointerException("Real NetworkPointId does not exist.");
        }
    }
}

