/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.text.ParseException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.NotThreadSafe;
import org.restcomm.sbc.bo.Account;
import org.restcomm.sbc.bo.Location;
import org.restcomm.sbc.bo.LocationFilter;
import org.restcomm.sbc.bo.LocationList;
import org.restcomm.sbc.bo.LocationNotFoundException;
import org.restcomm.sbc.bo.RestCommResponse;
import org.restcomm.sbc.configuration.RestcommConfiguration;
import org.restcomm.sbc.dao.AccountsDao;
import org.restcomm.sbc.dao.DaoManager;
import org.restcomm.sbc.managers.LocationManager;
import org.restcomm.sbc.rest.SecuredEndpoint;
import org.restcomm.sbc.rest.converter.LocationConverter;
import org.restcomm.sbc.rest.converter.LocationsListConverter;
import org.restcomm.sbc.rest.converter.RestCommResponseConverter;

@NotThreadSafe
public abstract class LocationsEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected DaoManager daos;
    protected Gson gson;
    protected GsonBuilder builder;
    protected XStream xstream;
    protected LocationsListConverter listConverter;
    protected AccountsDao accountsDao;
    protected String instanceId;
    protected LocationManager locationManager = LocationManager.getLocationManager();
    protected boolean normalizePhoneNumbers;

    @PostConstruct
    public void init() {
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        this.daos = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.accountsDao = this.daos.getAccountsDao();
        super.init(this.configuration);
        LocationConverter converter = new LocationConverter(this.configuration);
        this.listConverter = new LocationsListConverter(this.configuration);
        this.builder = new GsonBuilder();
        this.builder.registerTypeAdapter(Location.class, (Object)converter);
        this.builder.registerTypeAdapter(LocationList.class, (Object)this.listConverter);
        this.builder.setPrettyPrinting();
        this.gson = this.builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.xstream.registerConverter((Converter)this.listConverter);
        this.instanceId = RestcommConfiguration.getInstance().getMain().getInstanceId();
        this.normalizePhoneNumbers = this.configuration.getBoolean("normalize-numbers-for-outbound-calls");
    }

    protected Response getLocation(String aor, MediaType responseType) {
        Location location;
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Read:Locations");
        try {
            location = this.locationManager.getLocation(aor);
        }
        catch (LocationNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)location);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)location), (String)"application/json").build();
        }
        return null;
    }

    protected Response getLocations(UriInfo info, MediaType responseType) {
        LocationFilter filterForTotal;
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Read:Locations");
        boolean localInstanceOnly = true;
        try {
            String localOnly = (String)info.getQueryParameters().getFirst((Object)"localOnly");
            if (localOnly != null && localOnly.equalsIgnoreCase("false")) {
                localInstanceOnly = false;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String pageSize = (String)info.getQueryParameters().getFirst((Object)"PageSize");
        String page = (String)info.getQueryParameters().getFirst((Object)"Page");
        String user = (String)info.getQueryParameters().getFirst((Object)"User");
        String domain = (String)info.getQueryParameters().getFirst((Object)"Domain");
        String userAgent = (String)info.getQueryParameters().getFirst((Object)"UserAgent");
        String host = (String)info.getQueryParameters().getFirst((Object)"Host");
        String sport = (String)info.getQueryParameters().getFirst((Object)"Port");
        String transport = (String)info.getQueryParameters().getFirst((Object)"Transport");
        if (pageSize == null) {
            pageSize = "50";
        }
        if (page == null) {
            page = "0";
        }
        if (sport == null) {
            sport = "5060";
        }
        int port = Integer.parseInt(sport);
        int limit = Integer.parseInt(pageSize);
        int offset = page == "0" ? 0 : (Integer.parseInt(page) - 1) * Integer.parseInt(pageSize) + Integer.parseInt(pageSize);
        try {
            filterForTotal = localInstanceOnly ? new LocationFilter(user, domain, host, port, transport, userAgent, Integer.valueOf(limit), Integer.valueOf(offset), null) : new LocationFilter(user, domain, host, port, transport, userAgent, Integer.valueOf(limit), Integer.valueOf(offset), this.instanceId);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        int total = this.locationManager.getTotalLocations(filterForTotal);
        if (Integer.parseInt(page) > total / limit) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        LocationFilter filter = null;
        try {
            filter = localInstanceOnly ? new LocationFilter(user, domain, host, port, transport, userAgent, Integer.valueOf(limit), Integer.valueOf(offset), null) : new LocationFilter(user, domain, host, port, transport, userAgent, Integer.valueOf(limit), Integer.valueOf(offset), this.instanceId);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        List locations = this.locationManager.getLocations(filter);
        this.listConverter.setCount(Integer.valueOf(total));
        this.listConverter.setPage(Integer.valueOf(Integer.parseInt(page)));
        this.listConverter.setPageSize(Integer.valueOf(Integer.parseInt(pageSize)));
        this.listConverter.setPathUri(info.getRequestUri().getPath());
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse((Object)new LocationList(locations));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)new LocationList(locations)), (String)"application/json").build();
        }
        return null;
    }

    protected Response deleteLocation(String aor) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Delete:Locations");
        try {
            this.locationManager.getLocation(aor);
        }
        catch (LocationNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.locationManager.unregister(aor);
        return Response.ok().build();
    }
}

