/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.joda.time.DateTime;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.mobicents.servlet.sip.restcomm.util.StringUtils;
import org.restcomm.sbc.bo.CallDetailRecord;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.rest.converter.AbstractConverter;

@ThreadSafe
public final class CallDetailRecordConverter
extends AbstractConverter
implements JsonSerializer<CallDetailRecord> {
    private final String apiVersion;
    private final String rootUri;

    public CallDetailRecordConverter(Configuration configuration) {
        super(configuration);
        this.apiVersion = configuration.getString("api-version");
        this.rootUri = StringUtils.addSuffixIfNotPresent((String)configuration.getString("root-uri"), (String)"/");
    }

    public boolean canConvert(Class klass) {
        return CallDetailRecord.class.equals((Object)klass);
    }

    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        CallDetailRecord cdr = (CallDetailRecord)object;
        writer.startNode("Call");
        this.writeSid(cdr.getSid(), writer);
        this.writeInstanceId(cdr.getInstanceId(), writer);
        this.writeDateCreated(cdr.getDateCreated(), writer);
        this.writeDateUpdated(cdr.getDateUpdated(), writer);
        this.writeParentCallSid(cdr.getParentCallSid(), writer);
        this.writeTo(cdr.getTo(), writer);
        this.writeFrom(cdr.getFrom(), writer);
        this.writeStatus(cdr.getStatus(), writer);
        this.writeStartTime(cdr.getStartTime(), writer);
        this.writeEndTime(cdr.getEndTime(), writer);
        this.writeDuration(cdr.getDuration(), writer);
        this.writePrice(cdr.getPrice(), writer);
        this.writePriceUnit(cdr.getPriceUnit(), writer);
        this.writeDirection(cdr.getDirection(), writer);
        this.writeAnsweredBy(cdr.getAnsweredBy(), writer);
        this.writeApiVersion(cdr.getApiVersion(), writer);
        this.writeForwardedFrom(cdr.getForwardedFrom(), writer);
        this.writeCallerName(cdr.getCallerName(), writer);
        this.writeUri(cdr.getUri(), writer);
        this.writeRingDuration(cdr.getRingDuration(), writer);
        writer.endNode();
    }

    private String prefix(CallDetailRecord cdr) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.rootUri).append(this.apiVersion).append("/Calls/");
        buffer.append(cdr.getSid());
        return buffer.toString();
    }

    public JsonElement serialize(CallDetailRecord cdr, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(cdr.getSid(), object);
        this.writeInstanceId(cdr.getInstanceId(), object);
        this.writeDateCreated(cdr.getDateCreated(), object);
        this.writeDateUpdated(cdr.getDateUpdated(), object);
        this.writeParentCallSid(cdr.getParentCallSid(), object);
        this.writeTo(cdr.getTo(), object);
        this.writeFrom(cdr.getFrom(), object);
        this.writeStatus(cdr.getStatus(), object);
        this.writeStartTime(cdr.getStartTime(), object);
        this.writeEndTime(cdr.getEndTime(), object);
        this.writeDuration(cdr.getDuration(), object);
        this.writePriceUnit(cdr.getPriceUnit(), object);
        this.writeDirection(cdr.getDirection(), object);
        this.writeAnsweredBy(cdr.getAnsweredBy(), object);
        this.writeApiVersion(cdr.getApiVersion(), object);
        this.writeForwardedFrom(cdr.getForwardedFrom(), object);
        this.writeCallerName(cdr.getCallerName(), object);
        this.writeUri(cdr.getUri(), object);
        this.writeRingDuration(cdr.getRingDuration(), object);
        return object;
    }

    private void writeAnsweredBy(String answeredBy, HierarchicalStreamWriter writer) {
        writer.startNode("AnsweredBy");
        if (answeredBy != null) {
            writer.setValue(answeredBy);
        }
        writer.endNode();
    }

    private void writeAnsweredBy(String answeredBy, JsonObject object) {
        object.addProperty("answered_by", answeredBy);
    }

    private void writeCallerName(String callerName, HierarchicalStreamWriter writer) {
        writer.startNode("CallerName");
        if (callerName != null) {
            writer.setValue(callerName);
        }
        writer.endNode();
    }

    private void writeCallerName(String callerName, JsonObject object) {
        object.addProperty("caller_name", callerName);
    }

    private void writeDirection(String direction, HierarchicalStreamWriter writer) {
        writer.startNode("Direction");
        writer.setValue(direction);
        writer.endNode();
    }

    private void writeDirection(String direction, JsonObject object) {
        object.addProperty("direction", direction);
    }

    private void writeDuration(Integer duration, HierarchicalStreamWriter writer) {
        writer.startNode("Duration");
        if (duration != null) {
            writer.setValue(duration.toString());
        }
        writer.endNode();
    }

    private void writeDuration(Integer duration, JsonObject object) {
        object.addProperty("duration", (Number)duration);
    }

    private void writeRingDuration(Integer ringDuration, HierarchicalStreamWriter writer) {
        writer.startNode("Ring_duration");
        if (ringDuration != null) {
            writer.setValue(ringDuration.toString());
        }
        writer.endNode();
    }

    private void writeRingDuration(Integer ringDuration, JsonObject object) {
        object.addProperty("ring_duration", (Number)ringDuration);
    }

    private void writeForwardedFrom(String forwardedFrom, HierarchicalStreamWriter writer) {
        writer.startNode("ForwardedFrom");
        if (forwardedFrom != null) {
            writer.setValue(forwardedFrom);
        }
        writer.endNode();
    }

    private void writeForwardedFrom(String forwardedFrom, JsonObject object) {
        object.addProperty("forwarded_from", forwardedFrom);
    }

    private void writeParentCallSid(Sid sid, HierarchicalStreamWriter writer) {
        writer.startNode("ParentCallSid");
        if (sid != null) {
            writer.setValue(sid.toString());
        }
        writer.endNode();
    }

    private void writeParentCallSid(Sid sid, JsonObject object) {
        if (sid != null) {
            object.addProperty("parent_call_sid", sid.toString());
        }
    }

    private void writeEndTime(DateTime endTime, HierarchicalStreamWriter writer) {
        writer.startNode("EndTime");
        if (endTime != null) {
            writer.setValue(endTime.toString());
        }
        writer.endNode();
    }

    private void writeEndTime(DateTime endTime, JsonObject object) {
        if (endTime != null) {
            object.addProperty("end_time", endTime.toString());
        }
    }

    private void writeStartTime(DateTime startTime, HierarchicalStreamWriter writer) {
        writer.startNode("StartTime");
        if (startTime != null) {
            writer.setValue(startTime.toString());
        }
        writer.endNode();
    }

    private void writeStartTime(DateTime startTime, JsonObject object) {
        if (startTime != null) {
            object.addProperty("start_time", startTime.toString());
        }
    }

    private void writeInstanceId(String instanceId, HierarchicalStreamWriter writer) {
        if (instanceId != null && !instanceId.isEmpty()) {
            writer.startNode("InstanceId");
            writer.setValue(instanceId);
            writer.endNode();
        }
    }

    private void writeInstanceId(String instanceId, JsonObject object) {
        if (instanceId != null && !instanceId.isEmpty()) {
            object.addProperty("InstanceId", instanceId);
        }
    }
}

