/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest.converter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.bo.Location;
import org.restcomm.sbc.bo.LocationList;
import org.restcomm.sbc.rest.converter.AbstractConverter;

@ThreadSafe
public final class LocationsListConverter
extends AbstractConverter
implements JsonSerializer<LocationList> {
    Integer page;
    Integer pageSize;
    Integer total;
    String pathUri;

    public LocationsListConverter(Configuration configuration) {
        super(configuration);
    }

    public boolean canConvert(Class klass) {
        return LocationList.class.equals((Object)klass);
    }

    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        LocationList list = (LocationList)object;
        writer.startNode("Locations");
        writer.addAttribute("page", String.valueOf(this.page));
        writer.addAttribute("numpages", String.valueOf(this.getTotalPages()));
        writer.addAttribute("pagesize", String.valueOf(this.pageSize));
        writer.addAttribute("total", String.valueOf(this.getTotalPages()));
        writer.addAttribute("start", this.getFirstIndex());
        writer.addAttribute("end", this.getLastIndex(list));
        writer.addAttribute("uri", this.pathUri);
        writer.addAttribute("firstpageuri", this.getFirstPageUri());
        writer.addAttribute("previouspageuri", this.getPreviousPageUri());
        writer.addAttribute("nextpageuri", this.getNextPageUri(list));
        writer.addAttribute("lastpageuri", this.getLastPageUri());
        for (Location location : list.getLocations()) {
            context.convertAnother((Object)location);
        }
        writer.endNode();
    }

    public JsonObject serialize(LocationList locationList, Type type, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        JsonArray array = new JsonArray();
        for (Location location : locationList.getLocations()) {
            array.add(context.serialize((Object)location));
        }
        if (this.total != null && this.pageSize != null && this.page != null) {
            result.addProperty("page", (Number)this.page);
            result.addProperty("num_pages", (Number)this.getTotalPages());
            result.addProperty("page_size", (Number)this.pageSize);
            result.addProperty("total", (Number)this.total);
            result.addProperty("start", this.getFirstIndex());
            result.addProperty("end", this.getLastIndex(locationList));
            result.addProperty("uri", this.pathUri);
            result.addProperty("first_page_uri", this.getFirstPageUri());
            result.addProperty("previous_page_uri", this.getPreviousPageUri());
            result.addProperty("next_page_uri", this.getNextPageUri(locationList));
            result.addProperty("last_page_uri", this.getLastPageUri());
        }
        result.add("locations", (JsonElement)array);
        return result;
    }

    private int getTotalPages() {
        return this.total / this.pageSize;
    }

    private String getFirstIndex() {
        return String.valueOf(this.page * this.pageSize);
    }

    private String getLastIndex(LocationList list) {
        return String.valueOf(this.page.intValue() == this.getTotalPages() ? this.page * this.pageSize + list.getLocations().size() : this.pageSize - 1 + this.page * this.pageSize);
    }

    private String getFirstPageUri() {
        return this.pathUri + "?Page=0&PageSize=" + this.pageSize;
    }

    private String getPreviousPageUri() {
        return this.page == 0 ? "null" : this.pathUri + "?Page=" + (this.page - 1) + "&PageSize=" + this.pageSize;
    }

    private String getNextPageUri(LocationList list) {
        String lastSid = this.page.intValue() == this.getTotalPages() ? "null" : ((Location)list.getLocations().get(this.pageSize - 1)).getUser();
        return this.page.intValue() == this.getTotalPages() ? "null" : this.pathUri + "?Page=" + (this.page + 1) + "&PageSize=" + this.pageSize + "&AfterSid=" + lastSid;
    }

    private String getLastPageUri() {
        return this.pathUri + "?Page=" + this.getTotalPages() + "&PageSize=" + this.pageSize;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setCount(Integer count) {
        this.total = count;
    }

    public void setPathUri(String pathUri) {
        this.pathUri = pathUri;
    }
}

