/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.bo.Connector;
import org.restcomm.sbc.bo.shiro.ShiroResources;
import org.restcomm.sbc.dao.ConnectorsDao;
import org.restcomm.sbc.dao.DaoManager;
import org.restcomm.sbc.managers.Monitor;
import org.restcomm.sbc.managers.NetworkManager;
import org.restcomm.sbc.managers.jmx.JMXProvider;
import org.restcomm.sbc.managers.jmx.JMXProviderFactory;

public final class ServiceLauncher
extends SipServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(ServiceLauncher.class);

    public void destroy() {
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> ServiceLauncher Servlet init()");
        }
        ServletContext context = servletConfig.getServletContext();
        SipFactory sipFactory = (SipFactory)this.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
        Configuration configuration = (Configuration)context.getAttribute(Configuration.class.getName());
        ConfigurationCache.build((SipFactory)sipFactory, (Configuration)configuration);
        DaoManager storage = (DaoManager)ShiroResources.getInstance().get(DaoManager.class);
        try {
            this.bindConnectors(storage);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot bind connectors!", (Throwable)e);
        }
        Monitor monitor = Monitor.getMonitor();
        monitor.start();
    }

    private void bindConnectors(DaoManager storage) throws Exception {
        JMXProvider jmxManager = null;
        jmxManager = JMXProviderFactory.getJMXProvider();
        ConnectorsDao dao = storage.getConnectorsDao();
        for (Connector connector : dao.getConnectors()) {
            String npoint = connector.getPoint();
            String ipAddress = NetworkManager.getIpAddress((String)npoint);
            if (connector.getState() != Connector.State.UP) continue;
            boolean status = jmxManager.addSipConnector(ipAddress, connector.getPort(), connector.getTransport().toString());
            if (status) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Binding Connector on " + npoint + ":" + ipAddress + ":" + connector.getPort() + "/" + connector.getTransport().toString()));
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("CANNOT Bind Connector on " + npoint + ":" + ipAddress + ":" + connector.getPort() + "/" + connector.getTransport().toString()));
        }
    }
}

