/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.adapter.impl;

import java.net.NoRouteToHostException;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;
import org.mobicents.media.server.io.sdp.SdpException;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.adapter.ProtocolAdapter;
import org.restcomm.sbc.managers.ProtocolAdapterFactory;
import org.restcomm.sbc.media.MediaController;

public class TCPProtocolAdapter
extends ProtocolAdapter {
    private static transient Logger LOG = Logger.getLogger(TCPProtocolAdapter.class);
    private SipFactory sipFactory = ConfigurationCache.getSipFactory();
    private SIPMutableMessage m;

    @Override
    public Message adapt(Message message) throws NoRouteToHostException {
        this.m = (SIPMutableMessage)message;
        SipServletMessage sm = this.m.getContent();
        String sourceTransport = this.m.getSourceTransport();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(">> adapt() Adapting protocol [" + sourceTransport + "->" + this.getProtocol() + "]"));
        }
        String user = ((SipURI)sm.getFrom().getURI()).getUser();
        String host = ((SipURI)sm.getFrom().getURI()).getHost();
        int port = ((SipURI)sm.getFrom().getURI()).getPort();
        SipURI sipUri = this.sipFactory.createSipURI(user, host);
        sipUri.setTransportParam("tcp");
        sipUri.setPort(port);
        if (sm instanceof SipServletRequest) {
            ((SipServletRequest)sm).setRequestURI((URI)sipUri);
        }
        if (sm.getContentLength() > 0 && sm.getContentType().equalsIgnoreCase("application/sdp")) {
            message = this.adaptMedia(message);
        }
        this.m.setContent(sm);
        return this.m;
    }

    @Override
    protected String adaptSdp(MediaController mediaController, String host) throws SdpException {
        String sdpContent = mediaController.getProxySdp(host);
        if (this.m.getTarget() == 1) {
            sdpContent = mediaController.getAVPProxySdp(host);
        }
        return sdpContent;
    }

    @Override
    public String getProtocol() {
        return ProtocolAdapterFactory.PROTOCOL_TCP;
    }
}

