/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.bo;

import org.restcomm.sbc.bo.Sid;

public class Route {
    private Sid sid;
    private Sid accountSid;
    private Sid sourceConnector;
    private Sid targetConnector;

    public Route(Sid sid, Sid accountSid, Sid sourceConnector, Sid targetConnector) {
        this.sid = sid;
        this.sourceConnector = sourceConnector;
        this.targetConnector = targetConnector;
        this.accountSid = accountSid;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Sid getSourceConnector() {
        return this.sourceConnector;
    }

    public Sid getTargetConnector() {
        return this.targetConnector;
    }

    public Sid getAccountSid() {
        return this.accountSid;
    }

    public Sid getSid() {
        return this.sid;
    }

    public Route setSourceConnector(Sid sourceConnector) {
        return new Route(this.sid, this.accountSid, sourceConnector, this.targetConnector);
    }

    public Route setTargetConnector(Sid targetConnector) {
        return new Route(this.sid, this.accountSid, this.sourceConnector, targetConnector);
    }

    public Route setAccountSid(Sid accountSid) {
        return new Route(this.sid, accountSid, this.sourceConnector, this.targetConnector);
    }

    public static final class Builder {
        private Sid sid;
        private Sid accountSid;
        private Sid sourceConnectorSid;
        private Sid targetConnectorSid;

        private Builder() {
        }

        public Route build() {
            return new Route(this.sid, this.accountSid, this.sourceConnectorSid, this.targetConnectorSid);
        }

        public void setSourceConnectorSid(Sid sourceConnector) {
            this.sourceConnectorSid = sourceConnector;
        }

        public void setTargetConnectorSid(Sid targetConnector) {
            this.targetConnectorSid = targetConnector;
        }

        public void setAccountSid(Sid accountSid) {
            this.accountSid = accountSid;
        }

        public void setSid(Sid sid) {
            this.sid = sid;
        }
    }
}

