/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.chain.impl.invite;

import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.apache.log4j.Logger;
import org.restcomm.chain.ProcessorChain;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.ProcessorCallBack;
import org.restcomm.chain.processor.impl.DefaultProcessor;
import org.restcomm.chain.processor.impl.ProcessorParsingException;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.call.Call;
import org.restcomm.sbc.call.CallManager;
import org.restcomm.sbc.managers.MessageUtil;
import org.restcomm.sbc.media.MediaSession;

public class InviteProcessor
extends DefaultProcessor
implements ProcessorCallBack {
    private static transient Logger LOG = Logger.getLogger(InviteProcessor.class);
    private String name = "INVITE Processor";
    private CallManager callManager = CallManager.getCallManager();

    public InviteProcessor(ProcessorChain chain) {
        super(chain);
        this.chain = chain;
    }

    public InviteProcessor(String name, ProcessorChain chain) {
        this(chain);
        this.setName(name);
    }

    private void processInviteRequest(SIPMutableMessage message) {
        SipServletRequest request = (SipServletRequest)message.getContent();
        Object mediaSession = null;
        SipServletRequest oRequest = (SipServletRequest)request.getSession().getAttribute(MessageUtil.B2BUA_ORIG_REQUEST_ATTR);
        message.setContent(request);
    }

    private void processInviteResponse(SIPMutableMessage message) {
        SipServletResponse response = (SipServletResponse)message.getContent();
        String callSessionId = response.getRequest().getSession().getId();
        Call call = this.callManager.getCall(callSessionId);
        if (response.getStatus() == 200) {
            MediaSession mediaSession = (MediaSession)response.getRequest().getSession().getAttribute(MessageUtil.MEDIA_MANAGER);
            message.setContent(response);
        }
    }

    private void processByeRequest(SIPMutableMessage message) {
    }

    private void processAckRequest(SIPMutableMessage message) {
    }

    private void processPrackRequest(SIPMutableMessage message) {
    }

    private void processInfoRequest(SIPMutableMessage message) {
    }

    private void processCancelRequest(SIPMutableMessage message) {
    }

    private void processByeResponse(SIPMutableMessage message) {
    }

    private void processInfoResponse(SIPMutableMessage message) {
    }

    private void processCancelResponse(SIPMutableMessage message) {
    }

    private String getCallSessionId(SipServletRequest currentRequest) {
        SipServletRequest oRequest = (SipServletRequest)currentRequest.getSession().getAttribute(MessageUtil.B2BUA_ORIG_REQUEST_ATTR);
        return oRequest.getSession().getId();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getId() {
        return this.hashCode();
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ProcessorCallBack getCallback() {
        return this;
    }

    @Override
    public void doProcess(Message message) throws ProcessorParsingException {
        SIPMutableMessage m = (SIPMutableMessage)message;
        SipServletMessage sm = m.getContent();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> doProcess()");
        }
        if (sm instanceof SipServletRequest) {
            if (sm.getMethod().equals("INVITE")) {
                this.processInviteRequest(m);
            } else if (sm.getMethod().equals("BYE")) {
                this.processByeRequest(m);
            } else if (sm.getMethod().equals("ACK")) {
                this.processAckRequest(m);
            } else if (sm.getMethod().equals("PRACK")) {
                this.processPrackRequest(m);
            } else if (sm.getMethod().equals("CANCEL")) {
                this.processCancelRequest(m);
            } else if (sm.getMethod().equals("INFO")) {
                this.processInfoRequest(m);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Request METHOD " + sm.getMethod() + " not supported!"));
            }
        }
        if (sm instanceof SipServletResponse) {
            if (sm.getMethod().equals("INVITE")) {
                this.processInviteResponse(m);
            } else if (sm.getMethod().equals("BYE")) {
                this.processByeResponse(m);
            } else if (sm.getMethod().equals("CANCEL")) {
                this.processCancelResponse(m);
            } else if (sm.getMethod().equals("INFO")) {
                this.processInfoResponse(m);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Response METHOD " + sm.getMethod() + " not supported!"));
            }
        }
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }
}

