/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.chain.impl.messenger;

import javax.servlet.sip.SipServletMessage;
import org.apache.log4j.Logger;
import org.restcomm.chain.impl.DefaultSerialProcessorChain;
import org.restcomm.chain.impl.MalformedProcessorChainException;
import org.restcomm.chain.processor.Message;
import org.restcomm.chain.processor.Processor;
import org.restcomm.chain.processor.ProcessorCallBack;
import org.restcomm.chain.processor.ProcessorListener;
import org.restcomm.chain.processor.impl.ProcessorParsingException;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.chain.impl.B2BUABuilderProcessor;
import org.restcomm.sbc.chain.impl.DispatchDPIProcessor;
import org.restcomm.sbc.chain.impl.IncomingDPIProcessor;
import org.restcomm.sbc.chain.impl.NATHelperProcessor;
import org.restcomm.sbc.chain.impl.ProtocolAdaptProcessor;
import org.restcomm.sbc.chain.impl.TopologyHideProcessor;
import org.restcomm.sbc.chain.impl.messenger.MessengerProcessor;

public class DownstreamMessengerProcessorChain
extends DefaultSerialProcessorChain
implements ProcessorCallBack,
ProcessorListener {
    private static transient Logger LOG = Logger.getLogger(DownstreamMessengerProcessorChain.class);
    private String name = "Downstream MESSAGE Processor Chain";

    public DownstreamMessengerProcessorChain() {
        IncomingDPIProcessor c1 = new IncomingDPIProcessor(this);
        c1.addProcessorListener(this);
        B2BUABuilderProcessor c2 = new B2BUABuilderProcessor(this);
        c2.addProcessorListener(this);
        NATHelperProcessor c3 = new NATHelperProcessor(this);
        c3.addProcessorListener(this);
        MessengerProcessor c4 = new MessengerProcessor(this);
        c4.addProcessorListener(this);
        ProtocolAdaptProcessor c5 = new ProtocolAdaptProcessor(this);
        c5.addProcessorListener(this);
        TopologyHideProcessor c6 = new TopologyHideProcessor(this);
        c6.addProcessorListener(this);
        DispatchDPIProcessor c7 = new DispatchDPIProcessor("Dispatcher", this);
        c7.addProcessorListener(this);
        try {
            this.link(c1, c2);
            this.link(c2, c3);
            this.link(c3, c4);
            this.link(c4, c5);
            this.link(c5, c6);
            this.link(c6, c7);
        }
        catch (MalformedProcessorChainException e) {
            LOG.error((Object)"ERROR", (Throwable)e);
        }
        this.addProcessorListener(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ProcessorCallBack getCallback() {
        return this;
    }

    public SipServletMessage doProcess(SipServletMessage message) throws ProcessorParsingException {
        return message;
    }

    @Override
    public void doProcess(Message message) throws ProcessorParsingException {
        SIPMutableMessage m = (SIPMutableMessage)message;
        m.setContent(this.doProcess(m.getContent()));
    }

    @Override
    public String getVersion() {
        return "1.0.0";
    }

    @Override
    public void onProcessorProcessing(Message message, Processor processor) {
        SipServletMessage m = (SipServletMessage)message.getContent();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">>onProcessorProcessing() " + (Object)((Object)processor.getType()) + "(" + processor.getName() + ")[<-" + m.getFrom() + "][To:" + m.getTo() + "]"));
        }
    }

    @Override
    public void onProcessorEnd(Message message, Processor processor) {
        SipServletMessage m = (SipServletMessage)message.getContent();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">>onProcessorEnd() " + (Object)((Object)processor.getType()) + "(" + processor.getName() + ")[<-" + m.getRemoteAddr() + "][To:" + m.getTo() + "]"));
        }
    }

    @Override
    public void onProcessorAbort(Processor processor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">>onProcessorAbort() " + (Object)((Object)processor.getType()) + "(" + processor.getName() + ")"));
        }
    }

    @Override
    public void onProcessorUnlink(Processor processor) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(">>onProcessorUnlink() " + (Object)((Object)processor.getType()) + "(" + processor.getName() + ")"));
        }
    }
}

