/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.dao.mybatis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.bo.Statistics;
import org.restcomm.sbc.dao.DaoUtils;
import org.restcomm.sbc.dao.StatisticsDao;

@ThreadSafe
public final class MybatisStatisticsDao
implements StatisticsDao {
    private static final String namespace = "org.restcomm.sbc.dao.StatisticsDao.";
    private final SqlSessionFactory sessions;

    public MybatisStatisticsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRecord(Statistics entry) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.restcomm.sbc.dao.StatisticsDao.addEntry", this.toMap(entry));
            session.commit();
        }
    }

    @Override
    public Statistics getRecord(Sid sid) {
        Statistics entry = null;
        HashMap<String, Sid> parms = new HashMap<String, Sid>();
        parms.put("sid", sid);
        entry = this.getRecord("org.restcomm.sbc.dao.StatisticsDao.getEntry", parms);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statistics getRecord(String selector, Object parameters) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne(selector, parameters);
            if (result != null) {
                Statistics statistics = this.toRecord(result);
                return statistics;
            }
            Statistics statistics = null;
            return statistics;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Statistics> getRecords() {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.restcomm.sbc.dao.StatisticsDao.getEntries");
            ArrayList<Statistics> entrys = new ArrayList<Statistics>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    entrys.add(this.toRecord(result));
                }
            }
            ArrayList<Statistics> arrayList = entrys;
            return arrayList;
        }
    }

    @Override
    public void removeRecord(Sid sid) {
        this.removeRecord("org.restcomm.sbc.dao.StatisticsDao.removeEntry", "" + sid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRecord(String selector, Object parameters) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, parameters);
            session.commit();
        }
    }

    private Statistics toRecord(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        int mem = DaoUtils.readInteger(map.get("mem_usage"));
        int cpu = DaoUtils.readInteger(map.get("cpu_usage"));
        int liveCalls = DaoUtils.readInteger(map.get("live_call_count"));
        int rejectedCount = DaoUtils.readInteger(map.get("rejected_count"));
        int threatCount = DaoUtils.readInteger(map.get("threat_count"));
        double callRate = DaoUtils.readDouble(map.get("call_rate"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        return new Statistics(sid, mem, cpu, liveCalls, callRate, rejectedCount, threatCount, dateCreated);
    }

    private Map<String, Object> toMap(Statistics entry) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", entry.getSid());
        map.put("mem_usage", entry.getMemoryUsage());
        map.put("cpu_usage", entry.getCpuUsage());
        map.put("live_call_count", entry.getLiveCallsCount());
        map.put("rejected_count", entry.getCallRejectedCount());
        map.put("threat_count", entry.getThreatCount());
        map.put("call_rate", entry.getCallRate());
        map.put("date_created", DaoUtils.writeDateTime(entry.getDateCreated()));
        return map;
    }
}

