/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.managers;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;
import org.restcomm.sbc.bo.NetworkPoint;
import org.restcomm.sbc.bo.shiro.ShiroResources;
import org.restcomm.sbc.dao.DaoManager;
import org.restcomm.sbc.dao.NetworkPointsDao;

public class NetworkManager {
    private static transient Logger LOG = Logger.getLogger(NetworkManager.class);
    private static ArrayList<NetworkPoint> eths = new ArrayList();
    private static ArrayList<NetworkPoint> tots = new ArrayList();

    public static List<NetworkPoint> getNetworkPoints() {
        return eths;
    }

    public static List<NetworkPoint> getPersistentNetworkPoints() {
        NetworkManager.mergeNetworkPoints();
        return tots;
    }

    private static void mergeNetworkPoints() {
        DaoManager daos = ShiroResources.getInstance().get(DaoManager.class);
        NetworkPointsDao dao = daos.getNetworkPointDao();
        List<NetworkPoint> persistents = dao.getNetworkPoints();
        tots = new ArrayList<NetworkPoint>(eths);
        for (NetworkPoint realPoint : eths) {
            for (NetworkPoint persistentPoint : persistents) {
                if (!persistentPoint.getId().equals(realPoint.getId())) continue;
                persistentPoint.setMacAddress(realPoint.getMacAddress());
                persistentPoint.setDescription(realPoint.getDescription());
                persistentPoint.setAddress(realPoint.getAddress());
                tots.remove(realPoint);
                tots.add(persistentPoint);
            }
        }
    }

    public static NetworkPoint getNetworkPoint(String id) {
        for (NetworkPoint point : eths) {
            if (!point.getId().equals(id)) continue;
            return point;
        }
        return null;
    }

    public static String getIpAddress(String npoint) {
        NetworkPoint point = NetworkManager.getNetworkPoint(npoint);
        if (point != null && point.getAddress() != null) {
            return point.getAddress().getHostAddress();
        }
        return null;
    }

    public static NetworkPoint getNetworkPointByIpAddress(String ipAddress) {
        for (NetworkPoint point : eths) {
            if (LOG.isTraceEnabled()) {
                // empty if block
            }
            if (!point.getAddress().getHostAddress().equals(ipAddress)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Found point " + point.toPrint()));
            }
            return point;
        }
        return null;
    }

    public static NetworkPoint getPersistentNetworkPointByIpAddress(String ipAddress) {
        for (NetworkPoint point : tots) {
            if (LOG.isTraceEnabled()) {
                // empty if block
            }
            if (!point.getAddress().getHostAddress().equals(ipAddress)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Found point " + point.toPrint()));
            }
            return point;
        }
        return null;
    }

    public static NetworkPoint.Tag getTag(String ipAddress) {
        NetworkPoint point = NetworkManager.getPersistentNetworkPointByIpAddress(ipAddress);
        return point.getTag();
    }

    public static boolean exists(String id) {
        for (NetworkPoint point : eths) {
            if (!point.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    private static void init() throws SocketException {
        int id = 0;
        Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
        int group = 0;
        for (NetworkInterface netIf : Collections.list(nets)) {
            String mac = NetworkManager.makeMAC(netIf.getHardwareAddress());
            if ("".equals(mac.trim())) continue;
            List<InterfaceAddress> inetAddresses = netIf.getInterfaceAddresses();
            for (InterfaceAddress inetAddress : inetAddresses) {
                NetworkPoint point = new NetworkPoint(netIf.getName() + "-" + id);
                point.setGroup(group);
                point.setDescription(netIf.getDisplayName());
                point.setMacAddress(mac);
                point.setAddress(inetAddress.getAddress());
                point.setBroadcast(inetAddress.getBroadcast());
                point.setPrefixMask(inetAddress.getNetworkPrefixLength());
                ++id;
                eths.add(point);
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("Detected interface " + point.toPrint()));
            }
            ++group;
            id = 0;
        }
        NetworkManager.mergeNetworkPoints();
    }

    private static String makeMAC(byte[] mac) {
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        if (mac == null) {
            return "";
        }
        for (int i = 0; i < mac.length; ++i) {
            out.format("%02X", mac[i]);
        }
        return writer.toString();
    }

    static {
        try {
            NetworkManager.init();
        }
        catch (SocketException e) {
            LOG.error((Object)"Can't Obtain Interface data", (Throwable)e);
        }
    }
}

