/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtp.RtpPacket;
import org.mobicents.media.server.io.network.channel.PacketHandlerException;
import org.mobicents.media.server.io.sdp.format.RTPFormat;
import org.mobicents.media.server.io.sdp.format.RTPFormats;
import org.restcomm.sbc.media.PacketHandler;
import org.restcomm.sbc.media.dtls.DtlsHandler;

public class RtpHandler
implements PacketHandler {
    private static final Logger logger = Logger.getLogger(RtpHandler.class);
    private RTPFormats rtpFormats = new RTPFormats();
    private boolean loopable = false;
    private boolean receivable = false;
    private final RtpPacket rtpPacket = new RtpPacket(8192, true);
    private boolean secure = false;
    private DtlsHandler dtlsHandler;

    public boolean isLoopable() {
        return this.loopable;
    }

    public void setLoopable(boolean loopable) {
        this.loopable = loopable;
    }

    public boolean isReceivable() {
        return this.receivable;
    }

    public void setReceivable(boolean receivable) {
        this.receivable = receivable;
    }

    public void setFormatMap(RTPFormats rtpFormats) {
        this.rtpFormats = rtpFormats;
    }

    public RTPFormats getFormatMap() {
        return this.rtpFormats;
    }

    public void enableSrtp(DtlsHandler handler) {
        this.secure = true;
        this.dtlsHandler = handler;
    }

    public void disableSrtp() {
        this.secure = false;
        this.dtlsHandler = null;
    }

    public void reset() {
        if (this.secure) {
            this.disableSrtp();
        }
    }

    @Override
    public boolean canHandle(byte[] packet) {
        return this.canHandle(packet, packet.length, 0);
    }

    @Override
    public boolean canHandle(byte[] packet, int dataLength, int offset) {
        int version;
        byte b0;
        int b0Int;
        if (dataLength >= 12 && (b0Int = (b0 = packet[offset]) & 0xFF) > 127 && b0Int < 192 && 2 == (version = (b0 & 0xC0) >> 6)) {
            int type = packet[offset + 1] & 0xFF & 0x7F;
            int rtcpType = type + 128;
            switch (rtcpType) {
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 204: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public byte[] handle(byte[] packet, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        return this.handle(packet, packet.length, 0, localPeer, remotePeer);
    }

    @Override
    public byte[] handle(byte[] packet, int dataLength, int offset, InetSocketAddress localPeer, InetSocketAddress remotePeer) throws PacketHandlerException {
        if (this.secure && !this.dtlsHandler.isHandshakeComplete()) {
            return null;
        }
        if (this.secure) {
            byte[] decoded = this.dtlsHandler.decodeRTP(packet, offset, dataLength);
            if (decoded == null || decoded.length == 0) {
                logger.warn((Object)"SRTP packet is not valid! Dropping packet.");
                return null;
            }
            ByteBuffer buffer = this.rtpPacket.getBuffer();
            buffer.clear();
            buffer.put(decoded);
            buffer.flip();
        } else {
            ByteBuffer buffer = this.rtpPacket.getBuffer();
            buffer.clear();
            buffer.put(packet, offset, dataLength);
            buffer.flip();
        }
        if (this.rtpPacket.getVersion() != 0 && (this.receivable || this.loopable)) {
            if (this.rtpPacket.getBuffer().limit() > 0) {
                if (this.loopable) {
                    return packet;
                }
                int payloadType = this.rtpPacket.getPayloadType();
                RTPFormat format = this.rtpFormats.find(payloadType);
                if (format == null) {
                    logger.warn((Object)("Dropping packet because payload type (" + payloadType + ") is unknown."));
                }
            } else {
                logger.warn((Object)"Skipping packet because limit of the packets buffer is zero");
            }
        }
        return null;
    }

    @Override
    public int compareTo(PacketHandler o) {
        if (o == null) {
            return 1;
        }
        return 0;
    }
}

