/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.bo.Account;
import org.restcomm.sbc.rest.converter.AbstractConverter;

@ThreadSafe
public final class AccountConverter
extends AbstractConverter
implements JsonSerializer<Account> {
    public AccountConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return Account.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        Account account = (Account)object;
        writer.startNode("Account");
        this.writeSid(account.getSid(), writer);
        this.writeFriendlyName(account.getFriendlyName(), writer);
        this.writeEmailAddress(account, writer);
        this.writeStatus(account.getStatus().toString(), writer);
        this.writeRoleInfo(account.getRole(), writer);
        this.writeType(account.getType().toString(), writer);
        this.writeDateCreated(account.getDateCreated(), writer);
        this.writeDateUpdated(account.getDateUpdated(), writer);
        this.writeAuthToken(account, writer);
        this.writeUri(account.getUri(), writer);
        writer.endNode();
    }

    public JsonElement serialize(Account account, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeSid(account.getSid(), object);
        this.writeFriendlyName(account.getFriendlyName(), object);
        this.writeEmailAddress(account, object);
        this.writeType(account.getType().toString(), object);
        this.writeStatus(account.getStatus().toString(), object);
        this.writeRoleInfo(account.getRole(), object);
        this.writeDateCreated(account.getDateCreated(), object);
        this.writeDateUpdated(account.getDateUpdated(), object);
        this.writeAuthToken(account, object);
        this.writeUri(account.getUri(), object);
        return object;
    }

    private void writeAuthToken(Account account, HierarchicalStreamWriter writer) {
        writer.startNode("AuthToken");
        writer.setValue(account.getAuthToken());
        writer.endNode();
    }

    private void writeAuthToken(Account account, JsonObject object) {
        object.addProperty("auth_token", account.getAuthToken());
    }

    private void writeEmailAddress(Account account, HierarchicalStreamWriter writer) {
        writer.startNode("EmailAddress");
        writer.setValue(account.getEmailAddress());
        writer.endNode();
        writer.close();
    }

    private void writeEmailAddress(Account account, JsonObject object) {
        object.addProperty("email_address", account.getEmailAddress());
    }

    private void writeRoleInfo(String role, HierarchicalStreamWriter writer) {
        writer.startNode("Role");
        writer.setValue(role);
        writer.endNode();
        writer.close();
    }

    private void writeRoleInfo(String role, JsonObject object) {
        object.addProperty("role", role);
    }
}

