/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.bo.NetworkPoint;
import org.restcomm.sbc.rest.converter.AbstractConverter;

@ThreadSafe
public final class NetworkPointConverter
extends AbstractConverter
implements JsonSerializer<NetworkPoint> {
    public NetworkPointConverter(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean canConvert(Class klass) {
        return NetworkPoint.class.equals((Object)klass);
    }

    @Override
    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        NetworkPoint point = (NetworkPoint)object;
        writer.startNode("NetworkPoint");
        this.writeId(point.getId(), writer);
        this.writeMAC(point.getMacAddress(), writer);
        this.writeDescription(point.getDescription(), writer);
        this.writeTag(point.getTag().toString(), writer);
        this.writeAccountSid(point.getAccountSid(), writer);
        writer.endNode();
    }

    public JsonElement serialize(NetworkPoint point, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeId(point.getId(), object);
        this.writeMAC(point.getMacAddress(), object);
        this.writeDescription(point.getDescription(), object);
        this.writeTag(point.getTag().toString(), object);
        this.writeAccountSid(point.getAccountSid(), object);
        return object;
    }

    private void writeId(String id, HierarchicalStreamWriter writer) {
        writer.startNode("Id");
        if (id != null) {
            writer.setValue(id);
        }
        writer.endNode();
    }

    private void writeId(String id, JsonObject object) {
        object.addProperty("id", id);
    }

    private void writeMAC(String mac, HierarchicalStreamWriter writer) {
        writer.startNode("MacAddress");
        if (mac != null) {
            writer.setValue(mac);
        }
        writer.endNode();
    }

    private void writeMAC(String mac, JsonObject object) {
        object.addProperty("mac_address", mac);
    }

    private void writeDescription(String desc, HierarchicalStreamWriter writer) {
        writer.startNode("Description");
        if (desc != null) {
            writer.setValue(desc);
        }
        writer.endNode();
    }

    private void writeDescription(String desc, JsonObject object) {
        object.addProperty("description", desc);
    }
}

