/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest.converter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.lang.reflect.Type;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.bo.BanList;
import org.restcomm.sbc.rest.converter.AbstractConverter;

@ThreadSafe
public final class BanListConverter
extends AbstractConverter
implements JsonSerializer<BanList> {
    private BanList.Type color;

    public BanListConverter(BanList.Type color, Configuration configuration) {
        super(configuration);
        this.color = color;
    }

    public boolean canConvert(Class klass) {
        return BanList.class.equals((Object)klass);
    }

    public void marshal(Object object, HierarchicalStreamWriter writer, MarshallingContext context) {
        BanList banList = (BanList)object;
        writer.startNode(this.color.toString() + "List");
        this.writeDateCreated(banList.getDateCreated(), writer);
        this.writeDateExpires(banList.getDateExpires(), writer);
        this.writeAccountSid(banList.getAccountSid(), writer);
        this.writeIpAddress(banList.getIpAddress(), writer);
        this.writeAction(banList.getAction().toString(), writer);
        this.writeReason(banList.getReason().toString(), writer);
        writer.endNode();
    }

    public JsonElement serialize(BanList banList, Type type, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        this.writeDateCreated(banList.getDateCreated(), object);
        this.writeDateExpires(banList.getDateExpires(), object);
        this.writeAccountSid(banList.getAccountSid(), object);
        this.writeIpAddress(banList.getIpAddress(), object);
        this.writeReason(banList.getReason().toString(), object);
        this.writeAction(banList.getAction().toString(), object);
        return object;
    }

    private void writeIpAddress(String ipAddress, HierarchicalStreamWriter writer) {
        writer.startNode("IpAddress");
        if (ipAddress != null) {
            writer.setValue(ipAddress);
        }
        writer.endNode();
    }

    private void writeIpAddress(String ipAddress, JsonObject object) {
        object.addProperty("ip_address", ipAddress);
    }
}

