/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.dao.mybatis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.bo.BanList;
import org.restcomm.sbc.bo.BanListFilter;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.dao.BanListDao;
import org.restcomm.sbc.dao.DaoUtils;
import org.restcomm.sbc.managers.Monitor;

@ThreadSafe
public final class MybatisBanListDao
implements BanListDao {
    private static final String namespace = "org.restcomm.sbc.dao.BanListDao.";
    private final SqlSessionFactory sessions;
    private static transient Logger LOG = Logger.getLogger(MybatisBanListDao.class);

    public MybatisBanListDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBanList(BanList entry) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.restcomm.sbc.dao.BanListDao.addEntry", this.toMap(entry));
            session.commit();
        }
    }

    @Override
    public BanList getBanList(String name) {
        BanList entry = null;
        entry = this.getBanList("org.restcomm.sbc.dao.BanListDao.getEntryByIpAddress", name);
        if (entry == null) {
            entry = this.getBanList("org.restcomm.sbc.dao.BanListDao.getEntryByReason", name);
        }
        if (entry == null) {
            entry = this.getBanList("org.restcomm.sbc.dao.BanListDao.getEntry", name);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BanList getBanList(String selector, Object parameters) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Params=" + parameters));
        }
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne(selector, parameters);
            if (result != null) {
                BanList banList = this.toBanList(result);
                return banList;
            }
            BanList banList = null;
            return banList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BanList> getBanLists() {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.restcomm.sbc.dao.BanListDao.getEntries");
            ArrayList<BanList> entrys = new ArrayList<BanList>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    entrys.add(this.toBanList(result));
                }
            }
            ArrayList<BanList> arrayList = entrys;
            return arrayList;
        }
    }

    @Override
    public void updateBanList(BanList banList) {
        this.updateBanList("org.restcomm.sbc.dao.BanListDao.updateEntry", banList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBanList(String selector, BanList banList) {
        try (SqlSession session = this.sessions.openSession();){
            session.update(selector, this.toMap(banList));
            session.commit();
        }
    }

    @Override
    public void removeBanList(BanList banList) {
        this.removeBanList("org.restcomm.sbc.dao.BanListDao.removeEntry", banList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBanList(String selector, BanList banList) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, this.toMap(banList));
            session.commit();
        }
    }

    private BanList toBanList(Map<String, Object> map) {
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateExpires = DaoUtils.readDateTime(map.get("date_expires"));
        String ipAddress = DaoUtils.readString(map.get("ip_address"));
        Sid entrySid = DaoUtils.readSid(map.get("account_sid"));
        BanList.Reason reason = DaoUtils.readBanListReason(map.get("reason"));
        Monitor.Action action = DaoUtils.readMonitorAction(map.get("monitor_action"));
        return new BanList(dateCreated, dateExpires, ipAddress, entrySid, reason, action);
    }

    private Map<String, Object> toMap(BanList entry) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("date_created", DaoUtils.writeDateTime(entry.getDateCreated()));
        map.put("date_expires", DaoUtils.writeDateTime(entry.getDateExpires()));
        map.put("ip_address", entry.getIpAddress());
        map.put("account_sid", DaoUtils.writeSid(entry.getAccountSid()));
        map.put("reason", DaoUtils.writeBanListReason(entry.getReason()));
        map.put("monitor_action", DaoUtils.writeMonitorAction(entry.getAction()));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getTotalBanLists(BanListFilter filter) {
        try (SqlSession session = this.sessions.openSession();){
            Integer total;
            Integer n = total = (Integer)session.selectOne("org.restcomm.sbc.dao.BanListDao.getTotalBanListByUsingFilters", (Object)filter);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<BanList> getBanLists(BanListFilter filter) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.restcomm.sbc.dao.BanListDao.getBanListByUsingFilters", (Object)filter);
            ArrayList<BanList> banLists = new ArrayList<BanList>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    banLists.add(this.toBanList(result));
                }
            }
            ArrayList<BanList> arrayList = banLists;
            return arrayList;
        }
    }
}

