/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.dao.mybatis;

import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.joda.time.DateTime;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.ThreadSafe;
import org.restcomm.sbc.bo.CallDetailRecord;
import org.restcomm.sbc.bo.CallDetailRecordFilter;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.dao.CallDetailRecordsDao;
import org.restcomm.sbc.dao.DaoUtils;

@ThreadSafe
public final class MybatisCallDetailRecordsDao
implements CallDetailRecordsDao {
    private static final String namespace = "org.restcomm.sbc.dao.CallDetailRecordsDao.";
    private final SqlSessionFactory sessions;

    public MybatisCallDetailRecordsDao(SqlSessionFactory sessions) {
        this.sessions = sessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCallDetailRecord(CallDetailRecord cdr) {
        try (SqlSession session = this.sessions.openSession();){
            session.insert("org.restcomm.sbc.dao.CallDetailRecordsDao.addCallDetailRecord", this.toMap(cdr));
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallDetailRecord getCallDetailRecord(Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            Map result = (Map)session.selectOne("org.restcomm.sbc.dao.CallDetailRecordsDao.getCallDetailRecord", (Object)sid.toString());
            if (result != null) {
                CallDetailRecord callDetailRecord = this.toCallDetailRecord(result);
                return callDetailRecord;
            }
            CallDetailRecord callDetailRecord = null;
            return callDetailRecord;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getTotalCallDetailRecords(CallDetailRecordFilter filter) {
        try (SqlSession session = this.sessions.openSession();){
            Integer total;
            Integer n = total = (Integer)session.selectOne("org.restcomm.sbc.dao.CallDetailRecordsDao.getTotalCallDetailRecordByUsingFilters", (Object)filter);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CallDetailRecord> getCallDetailRecords(CallDetailRecordFilter filter) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList("org.restcomm.sbc.dao.CallDetailRecordsDao.getCallDetailRecordByUsingFilters", (Object)filter);
            ArrayList<CallDetailRecord> cdrs = new ArrayList<CallDetailRecord>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    cdrs.add(this.toCallDetailRecord(result));
                }
            }
            ArrayList<CallDetailRecord> arrayList = cdrs;
            return arrayList;
        }
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecords(Sid accountSid) {
        return this.getCallDetailRecords("org.restcomm.sbc.dao.CallDetailRecordsDao.getCallDetailRecords", accountSid.toString());
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsByRecipient(String recipient) {
        return this.getCallDetailRecords("org.restcomm.sbc.dao.CallDetailRecordsDao.getCallDetailRecordsByRecipient", recipient);
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsBySender(String sender) {
        return this.getCallDetailRecords("org.restcomm.sbc.dao.CallDetailRecordsDao.getCallDetailRecordsBySender", sender);
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsByStatus(String status) {
        return this.getCallDetailRecords("org.restcomm.sbc.dao.CallDetailRecordsDao.getCallDetailRecordsByStatus", status);
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsByStartTime(DateTime startTime) {
        return this.getCallDetailRecords("org.restcomm.sbc.dao.CallDetailRecordsDao.getCallDetailRecordsByStartTime", startTime.toDate());
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsByEndTime(DateTime endTime) {
        return this.getCallDetailRecords("org.restcomm.sbc.dao.CallDetailRecordsDao.getCallDetailRecordsByEndTime", endTime.toDate());
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsByStarTimeAndEndTime(DateTime endTime) {
        return this.getCallDetailRecords("org.restcomm.sbc.dao.CallDetailRecordsDao.getCallDetailRecordsByStarTimeAndEndTime", endTime.toDate());
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsByParentCall(Sid parentCallSid) {
        return this.getCallDetailRecords("org.restcomm.sbc.dao.CallDetailRecordsDao.getCallDetailRecordsByParentCall", parentCallSid.toString());
    }

    @Override
    public List<CallDetailRecord> getCallDetailRecordsByInstanceId(Sid instanceId) {
        return this.getCallDetailRecords("org.restcomm.sbc.dao.CallDetailRecordsDao.getCallDetailRecordsByInstanceId", instanceId.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CallDetailRecord> getCallDetailRecords(String selector, Object input) {
        try (SqlSession session = this.sessions.openSession();){
            List results = session.selectList(selector, input);
            ArrayList<CallDetailRecord> cdrs = new ArrayList<CallDetailRecord>();
            if (results != null && !results.isEmpty()) {
                for (Map result : results) {
                    cdrs.add(this.toCallDetailRecord(result));
                }
            }
            ArrayList<CallDetailRecord> arrayList = cdrs;
            return arrayList;
        }
    }

    @Override
    public void removeCallDetailRecord(Sid sid) {
        this.removeCallDetailRecords("org.restcomm.sbc.dao.CallDetailRecordsDao.removeCallDetailRecord", sid);
    }

    @Override
    public void removeCallDetailRecords(Sid accountSid) {
        this.removeCallDetailRecords("org.restcomm.sbc.dao.CallDetailRecordsDao.removeCallDetailRecords", accountSid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCallDetailRecords(String selector, Sid sid) {
        try (SqlSession session = this.sessions.openSession();){
            session.delete(selector, (Object)sid.toString());
            session.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCallDetailRecord(CallDetailRecord cdr) {
        try (SqlSession session = this.sessions.openSession();){
            session.update("org.restcomm.sbc.dao.CallDetailRecordsDao.updateCallDetailRecord", this.toMap(cdr));
            session.commit();
        }
    }

    private CallDetailRecord toCallDetailRecord(Map<String, Object> map) {
        Sid sid = DaoUtils.readSid(map.get("sid"));
        String instanceId = DaoUtils.readString(map.get("instanceid"));
        Sid parentCallSid = DaoUtils.readSid(map.get("parent_call_sid"));
        DateTime dateCreated = DaoUtils.readDateTime(map.get("date_created"));
        DateTime dateUpdated = DaoUtils.readDateTime(map.get("date_updated"));
        String to = DaoUtils.readString(map.get("recipient"));
        String from = DaoUtils.readString(map.get("sender"));
        String status = DaoUtils.readString(map.get("status"));
        DateTime startTime = DaoUtils.readDateTime(map.get("start_time"));
        DateTime endTime = DaoUtils.readDateTime(map.get("end_time"));
        Integer duration = DaoUtils.readInteger(map.get("duration"));
        Integer ringDuration = DaoUtils.readInteger(map.get("ring_duration"));
        BigDecimal price = DaoUtils.readBigDecimal(map.get("price"));
        Currency priceUnit = DaoUtils.readCurrency(map.get("price_unit"));
        String direction = DaoUtils.readString(map.get("direction"));
        String answeredBy = DaoUtils.readString(map.get("answered_by"));
        String apiVersion = DaoUtils.readString(map.get("api_version"));
        String forwardedFrom = DaoUtils.readString(map.get("forwarded_from"));
        String callerName = DaoUtils.readString(map.get("caller_name"));
        URI uri = DaoUtils.readUri(map.get("uri"));
        String callPath = DaoUtils.readString(map.get("call_path"));
        Boolean muted = DaoUtils.readBoolean(map.get("muted"));
        Boolean onHold = DaoUtils.readBoolean(map.get("on_hold"));
        return new CallDetailRecord(sid, instanceId, parentCallSid, dateCreated, dateUpdated, to, from, status, startTime, endTime, duration, price, priceUnit, direction, answeredBy, apiVersion, forwardedFrom, callerName, uri, callPath, ringDuration, muted, onHold);
    }

    private Map<String, Object> toMap(CallDetailRecord cdr) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sid", DaoUtils.writeSid(cdr.getSid()));
        map.put("instanceid", cdr.getInstanceId());
        map.put("parent_call_sid", DaoUtils.writeSid(cdr.getParentCallSid()));
        map.put("date_created", DaoUtils.writeDateTime(cdr.getDateCreated()));
        map.put("date_updated", DaoUtils.writeDateTime(cdr.getDateUpdated()));
        map.put("to", cdr.getTo());
        map.put("from", cdr.getFrom());
        map.put("status", cdr.getStatus());
        map.put("start_time", DaoUtils.writeDateTime(cdr.getStartTime()));
        map.put("end_time", DaoUtils.writeDateTime(cdr.getEndTime()));
        map.put("duration", cdr.getDuration());
        map.put("ring_duration", cdr.getRingDuration());
        map.put("price", DaoUtils.writeBigDecimal(cdr.getPrice()));
        map.put("direction", cdr.getDirection());
        map.put("answered_by", cdr.getAnsweredBy());
        map.put("api_version", cdr.getApiVersion());
        map.put("forwarded_from", cdr.getForwardedFrom());
        map.put("caller_name", cdr.getCallerName());
        map.put("uri", DaoUtils.writeUri(cdr.getUri()));
        map.put("call_path", cdr.getCallPath());
        map.put("muted", cdr.isMuted());
        map.put("on_hold", cdr.isOnHold());
        return map;
    }
}

