/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.loader;

import org.restcomm.sbc.loader.ObjectInstantiationException;

public final class ObjectFactory {
    private final ClassLoader loader;

    public ObjectFactory() {
        this.loader = this.getClass().getClassLoader();
    }

    public ObjectFactory(ClassLoader loader) {
        this.loader = loader;
    }

    public Object getObjectInstance(String name) throws ObjectInstantiationException {
        try {
            Class<?> klass = this.loader.loadClass(name);
            return klass.newInstance();
        }
        catch (ClassNotFoundException exception) {
            throw new ObjectInstantiationException(exception);
        }
        catch (InstantiationException exception) {
            throw new ObjectInstantiationException(exception);
        }
        catch (IllegalAccessException exception) {
            throw new ObjectInstantiationException(exception);
        }
    }
}

