/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.managers;

import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.sip.Address;
import javax.servlet.sip.ServletParseException;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipURI;
import javax.servlet.sip.URI;
import org.apache.log4j.Logger;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.bo.Connector;
import org.restcomm.sbc.bo.NetworkPoint;
import org.restcomm.sbc.bo.Route;
import org.restcomm.sbc.bo.shiro.ShiroResources;
import org.restcomm.sbc.dao.ConnectorsDao;
import org.restcomm.sbc.dao.DaoManager;
import org.restcomm.sbc.dao.RoutesDao;
import org.restcomm.sbc.managers.NetworkManager;

public class RouteManager {
    private static RouteManager routeManager;
    private HashMap<String, Connector> dmzTable = null;
    private HashMap<String, Connector> conTable = null;
    private static transient Logger LOG;

    private RouteManager() {
        this.updateRoutingTable();
    }

    public static RouteManager getRouteManager() {
        if (routeManager == null) {
            routeManager = new RouteManager();
        }
        return routeManager;
    }

    public void updateRoutingTable() {
        this.dmzTable = new HashMap();
        this.conTable = new HashMap();
        DaoManager daos = ShiroResources.getInstance().get(DaoManager.class);
        RoutesDao rdao = daos.getRoutesDao();
        ConnectorsDao cdao = daos.getConnectorsDao();
        List<Route> dmzRoutes = rdao.getRoutes();
        for (Route dmzRoute : dmzRoutes) {
            Connector source = cdao.getConnector(dmzRoute.getSourceConnector());
            Connector target = cdao.getConnector(dmzRoute.getTargetConnector());
            this.dmzTable.put(NetworkManager.getIpAddress(source.getPoint()) + ":" + (Object)((Object)source.getTransport()) + ":" + source.getPort(), target);
            this.conTable.put(NetworkManager.getIpAddress(source.getPoint()) + ":" + (Object)((Object)source.getTransport()) + ":" + source.getPort(), source);
            if (!LOG.isInfoEnabled()) continue;
            LOG.info((Object)("DMZ Route add " + source.toPrint() + " => " + target.toPrint()));
            LOG.info((Object)("DMZ Connector add " + source.toPrint()));
        }
    }

    public Address getRegistrationContactAddress(SipServletRequest request) throws NoRouteToHostException, ServletParseException {
        SipURI uri = (SipURI)request.getFrom().getURI();
        SipFactory sipFactory = ConfigurationCache.getSipFactory();
        Connector connector = null;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Building Route to MZ for: " + uri.getHost() + ":" + uri.getPort() + ";transport=" + uri.getTransportParam() + "|" + request.getTransport() + "|" + request.getInitialTransport()));
        }
        connector = this.getRouteToMZ(uri.getHost(), uri.getPort(), uri.getTransportParam());
        SipURI contactUri = sipFactory.createSipURI(uri.getUser(), NetworkManager.getIpAddress(connector.getPoint()));
        contactUri.setPort(connector.getPort());
        contactUri.setTransportParam(connector.getTransport().toString());
        return sipFactory.createAddress((URI)contactUri);
    }

    public Address getContactAddress(String displayName, String user, String transport, InetSocketAddress address) throws NoRouteToHostException {
        Address contactUri;
        SipFactory sipFactory = ConfigurationCache.getSipFactory();
        String stringUri = "";
        if (displayName == null) {
            displayName = user;
        }
        try {
            stringUri = displayName + " <sip:" + user + "@" + address.getHostString() + ":" + address.getPort() + ">";
            contactUri = sipFactory.createAddress(stringUri);
        }
        catch (ServletParseException e) {
            throw new NoRouteToHostException("Cannot create Contact Address " + stringUri);
        }
        if (transport != null && !"".equals(transport.trim())) {
            contactUri.setParameter("transport", transport);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("from-Outbound-Intf  " + address.toString()));
            LOG.trace((Object)("getContactAddress() " + contactUri.toString()));
        }
        return contactUri;
    }

    public Address getFromAddress(SipURI fromURI, InetSocketAddress address) throws NoRouteToHostException {
        Address contactUri;
        SipFactory sipFactory = ConfigurationCache.getSipFactory();
        String stringUri = "";
        String user = fromURI.getUser();
        String transport = fromURI.getTransportParam();
        String tag = fromURI.getParameter("tag");
        int port = fromURI.getPort();
        if (port <= 0) {
            port = 5060;
        }
        try {
            stringUri = user + " <sip:" + user + "@" + address.getHostString() + ":" + port + ">";
            contactUri = sipFactory.createAddress(stringUri);
        }
        catch (ServletParseException e) {
            throw new NoRouteToHostException("Cannot create From Address " + stringUri);
        }
        if (transport != null && !"".equals(transport.trim())) {
            contactUri.setParameter("transport", transport);
        }
        contactUri.setParameter("tag", tag);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("from-Outbound-Intf  " + address.toString()));
            LOG.trace((Object)("getFromAddress() " + contactUri.toString()));
        }
        return contactUri;
    }

    public Connector getRouteToMZ(String sourceHost, int sourcePort, String sourceTransport) throws NoRouteToHostException {
        Connector connector;
        if (sourceTransport == null) {
            sourceTransport = "UDP";
        }
        if (sourcePort < 0) {
            sourcePort = 5060;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("oo Getting route to MZ for host=" + sourceHost + " transport=" + sourceTransport + " port=" + sourcePort));
        }
        if ((connector = this.dmzTable.get(sourceHost + ":" + sourceTransport.toUpperCase() + ":" + sourcePort)) == null) {
            throw new NoRouteToHostException("No source Connector for " + sourceHost + ":" + sourceTransport + ":" + sourcePort);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ooo " + connector.toPrint()));
        }
        return connector;
    }

    public Connector getDMZConnector(String sourceHost, int sourcePort, String sourceTransport) throws NoRouteToHostException {
        Connector connector;
        if (sourceTransport == null) {
            sourceTransport = "UDP";
        }
        if (sourcePort < 0) {
            sourcePort = 5060;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("oo Getting DMZ Connector for host=" + sourceHost + " transport=" + sourceTransport + " port=" + sourcePort));
        }
        if ((connector = this.conTable.get(sourceHost + ":" + sourceTransport.toUpperCase() + ":" + sourcePort)) == null) {
            throw new NoRouteToHostException("No Connector for " + sourceHost + ":" + sourceTransport + ":" + sourcePort);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ooo " + connector.toPrint()));
        }
        return connector;
    }

    public InetSocketAddress getOutboundProxy(String connectorSid) {
        for (Connector connector : this.conTable.values()) {
            if (!connector.getSid().toString().equals(connectorSid)) continue;
            return connector.getOutboundInterface();
        }
        return null;
    }

    public Connector getDMZConnector(String connectorSid) {
        for (Connector connector : this.conTable.values()) {
            if (!connector.getSid().toString().equals(connectorSid)) continue;
            return connector;
        }
        return null;
    }

    public Connector getRouteToMZ(SipServletMessage sourceMessage) throws NoRouteToHostException {
        Connector connector;
        String sourceHost = sourceMessage.getLocalAddr();
        String sourceTransport = sourceMessage.getTransport();
        int sourcePort = sourceMessage.getLocalPort();
        if (sourceTransport == null) {
            sourceTransport = "UDP";
        }
        if (sourcePort < 0) {
            sourcePort = 5060;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("oo Getting MZ Connector for host=" + sourceHost + " transport=" + sourceTransport + " port=" + sourcePort));
        }
        if ((connector = this.dmzTable.get(sourceHost + ":" + sourceTransport.toUpperCase() + ":" + sourcePort)) == null) {
            throw new NoRouteToHostException("No source Connector for " + sourceHost + ":" + sourceTransport + ":" + sourcePort);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("ooo " + connector.toPrint()));
        }
        return connector;
    }

    public static boolean isFromDMZ(SipServletMessage message) {
        boolean isFromDMZ;
        String host = message.getLocalAddr();
        boolean bl = isFromDMZ = NetworkManager.getTag(host) == NetworkPoint.Tag.DMZ;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Message " + message.getMethod() + " comming from " + (isFromDMZ ? "DMZ" : "MZ") + "@" + host));
        }
        return isFromDMZ;
    }

    static {
        LOG = Logger.getLogger(RouteManager.class);
    }
}

