/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.media.srtp;

import java.io.IOException;
import java.nio.channels.DatagramChannel;
import org.apache.log4j.Logger;
import org.mobicents.media.server.impl.rtp.CnameGenerator;
import org.mobicents.media.server.impl.rtp.RtpListener;
import org.mobicents.media.server.io.sdp.SdpException;
import org.mobicents.media.server.io.sdp.SessionDescription;
import org.mobicents.media.server.io.sdp.SessionDescriptionParser;
import org.mobicents.media.server.io.sdp.dtls.attributes.FingerprintAttribute;
import org.mobicents.media.server.io.sdp.fields.MediaDescriptionField;
import org.mobicents.media.server.io.sdp.format.RTPFormats;
import org.mobicents.media.server.io.sdp.rtcp.attributes.RtcpAttribute;
import org.mobicents.media.server.spi.Connection;
import org.mobicents.media.server.spi.ConnectionFailureListener;
import org.mobicents.media.server.spi.ConnectionMode;
import org.mobicents.media.server.spi.ConnectionType;
import org.mobicents.media.server.spi.ModeNotSupportedException;
import org.mobicents.media.server.utils.Text;
import org.restcomm.sbc.media.AudioChannel;
import org.restcomm.sbc.media.MediaChannel;
import org.restcomm.sbc.media.MediaController;
import org.restcomm.sbc.media.MediaZone;
import org.restcomm.sbc.media.SdpFactory;
import org.restcomm.sbc.media.srtp.BaseConnection;

public class RtpConnection
extends BaseConnection
implements RtpListener {
    private static final Logger logger = Logger.getLogger(RtpConnection.class);
    private String cname;
    private boolean local;
    private SessionDescription localSdp;
    private SessionDescription remoteSdp;
    private ConnectionFailureListener connectionFailureListener;
    private AudioChannel audioChannel;
    private String originalHost;
    private Object originalPort;

    public RtpConnection(MediaController controller, String originalHost, int originalPort) {
        this.originalHost = originalHost;
        this.originalPort = originalPort;
        this.audioChannel = new AudioChannel(originalHost, originalPort);
        this.local = false;
        this.cname = CnameGenerator.generateCname();
        this.audioChannel.setCname(this.cname);
    }

    public void setNegotiatedFormats(RTPFormats formats) {
        this.audioChannel.setFormats(formats);
    }

    public void generateCname() {
        this.cname = CnameGenerator.generateCname();
    }

    public String getCname() {
        return this.cname;
    }

    @Override
    public boolean getIsLocal() {
        return this.local;
    }

    @Override
    public void setIsLocal(boolean isLocal) {
        this.local = isLocal;
    }

    @Override
    public void setOtherParty(Connection other) throws IOException {
        throw new IOException("Applicable only for a local connection");
    }

    public void setOtherParty(MediaZone.Direction direction, DatagramChannel localChannel, byte[] descriptor) throws IOException {
        try {
            this.remoteSdp = SessionDescriptionParser.parse((String)new String(descriptor));
            this.setOtherParty(direction == MediaZone.Direction.ANSWER, localChannel);
        }
        catch (SdpException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void setOtherParty(byte[] descriptor) throws IOException {
    }

    @Override
    public void setOtherParty(Text descriptor) throws IOException {
        this.setOtherParty(descriptor.toString().getBytes());
    }

    private void setOtherParty(boolean outbound, DatagramChannel localChannel) throws IOException {
        if (outbound) {
            this.setOtherPartyOutboundCall();
        } else {
            this.setOtherPartyInboundCall(localChannel);
        }
    }

    private void setOtherPartyInboundCall(DatagramChannel localChannel) throws IOException {
        MediaDescriptionField remoteApplication;
        MediaDescriptionField remoteAudio = this.remoteSdp.getMediaDescription("audio");
        if (remoteAudio != null) {
            this.audioChannel.open();
            this.setupAudioChannelInbound(localChannel, remoteAudio);
        }
        String bindAddress = this.local ? this.originalHost : this.originalHost;
        String externalAddress = this.originalHost;
        this.localSdp = SdpFactory.buildSdp(false, bindAddress, externalAddress, this.audioChannel);
        MediaDescriptionField remoteVideo = this.remoteSdp.getMediaDescription("video");
        if (remoteVideo != null) {
            SdpFactory.rejectMediaField(this.localSdp, remoteVideo);
        }
        if ((remoteApplication = this.remoteSdp.getMediaDescription("application")) != null) {
            SdpFactory.rejectMediaField(this.localSdp, remoteApplication);
        }
        try {
            this.join();
        }
        catch (Exception e) {
            logger.warn((Object)"Could not set connection state to OPEN", (Throwable)e);
        }
    }

    private void setOtherPartyOutboundCall() throws IOException {
        MediaDescriptionField remoteAudio = this.remoteSdp.getMediaDescription("audio");
        if (remoteAudio != null) {
            if (this.audioChannel.isDtlsEnabled()) {
                FingerprintAttribute fingerprint = remoteAudio.getFingerprint();
                this.audioChannel.setRemoteFingerprint(fingerprint.getHashFunction(), fingerprint.getFingerprint());
            }
            this.setupAudioChannelOutbound(remoteAudio);
        }
        try {
            this.join();
        }
        catch (Exception e) {
            logger.warn((Object)"Could not set connection state to OPEN", (Throwable)e);
        }
    }

    private void setupAudioChannelInbound(DatagramChannel localChannel, MediaDescriptionField remoteAudio) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)">> setupAudioChannelInbound()");
        }
        this.audioChannel.bind(localChannel, remoteAudio.isRtcpMux());
        boolean enableIce = remoteAudio.containsIce();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("RemoteAudio  " + remoteAudio.getConnection().getAddress() + ":" + remoteAudio.getPort()));
            logger.trace((Object)("LocalChannel Remote:" + localChannel.getRemoteAddress() + ", Local:" + localChannel.getLocalAddress()));
            logger.trace((Object)("Enable ICE? :" + enableIce));
            logger.trace((Object)("RTPMux? :" + remoteAudio.isRtcpMux()));
        }
        if (enableIce) {
            this.audioChannel.enableICE(this.originalHost, remoteAudio.isRtcpMux());
        } else {
            String remoteAddr = remoteAudio.getConnection().getAddress();
            this.audioChannel.connectRtp(remoteAddr, remoteAudio.getPort());
            this.audioChannel.connectRtcp(remoteAddr, remoteAudio.getRtcpPort());
        }
        boolean enableDtls = this.remoteSdp.containsDtls();
        if (enableDtls) {
            FingerprintAttribute fingerprint = this.remoteSdp.getFingerprint(this.audioChannel.getMediaType());
            this.audioChannel.enableDTLS(fingerprint.getHashFunction(), fingerprint.getFingerprint());
        }
    }

    private void setupAudioChannelOutbound(MediaDescriptionField remoteAudio) throws IOException {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)">> setupAudioChannelOutbound()");
        }
        String remoteRtpAddress = remoteAudio.getConnection().getAddress();
        int remoteRtpPort = remoteAudio.getPort();
        boolean connectNow = !this.audioChannel.isIceEnabled();
        this.audioChannel.connectRtp(remoteRtpAddress, remoteRtpPort);
        boolean remoteRtcpMux = remoteAudio.isRtcpMux();
        if (remoteRtcpMux) {
            this.audioChannel.connectRtcp(remoteRtpAddress, remoteRtpPort);
        } else {
            RtcpAttribute remoteRtcp = remoteAudio.getRtcp();
            if (remoteRtcp == null) {
                this.audioChannel.connectRtcp(remoteRtpAddress, remoteRtpPort + 1);
            } else {
                String remoteRtcpAddress = remoteRtcp.getAddress();
                if (remoteRtcpAddress == null) {
                    remoteRtcpAddress = remoteRtpAddress;
                }
                int remoteRtcpPort = remoteRtcp.getPort();
                this.audioChannel.connectRtcp(remoteRtcpAddress, remoteRtcpPort);
            }
        }
    }

    @Override
    public void setMode(ConnectionMode mode) throws ModeNotSupportedException {
        this.audioChannel.setConnectionMode(mode);
        super.setMode(mode);
    }

    @Override
    public String getDescriptor() {
        return this.localSdp == null ? "" : this.localSdp.toString();
    }

    public void generateOffer(boolean webrtc) throws IOException {
    }

    public void generateOffer(DatagramChannel localChannel, boolean webrtc) throws IOException {
        if (!this.audioChannel.isOpen()) {
            this.audioChannel.open();
            this.audioChannel.bind(localChannel, webrtc);
            if (webrtc) {
                this.audioChannel.enableICE(this.originalHost, true);
                this.audioChannel.enableDTLS();
            }
            String bindAddress = this.local ? this.originalHost : this.originalHost;
            String externalAddress = this.originalHost;
            this.localSdp = SdpFactory.buildSdp(true, bindAddress, externalAddress, new MediaChannel[0]);
            this.remoteSdp = null;
        }
        this.generateOffer(webrtc);
    }

    public SessionDescription getLocalSdp() {
        return this.localSdp;
    }

    @Override
    public String getLocalDescriptor() {
        return this.localSdp == null ? "" : this.localSdp.toString();
    }

    @Override
    public String getRemoteDescriptor() {
        return this.remoteSdp == null ? "" : this.remoteSdp.toString();
    }

    public SessionDescription getRemoteSdp() {
        return this.remoteSdp;
    }

    public boolean isAvailable() {
        return this.audioChannel.isAvailable();
    }

    public String toString() {
        return "RTP Connection [" + this.getEndpoint().getLocalName() + "]";
    }

    private void closeResources() {
        if (this.audioChannel.isOpen()) {
            this.audioChannel.close();
        }
    }

    private void reset() {
        this.localSdp = null;
        this.remoteSdp = null;
    }

    public void onRtpFailure(String message) {
        if (this.audioChannel.isOpen()) {
            logger.warn((Object)message);
            this.onFailed();
        }
    }

    public void onRtpFailure(Throwable e) {
        String message = "RTP failure!";
        if (e != null) {
            message = message + " Reason: " + e.getMessage();
        }
        this.onRtpFailure(message);
    }

    public void onRtcpFailure(String e) {
        if (this.audioChannel.isOpen()) {
            logger.warn((Object)e);
            this.onFailed();
        }
    }

    public void onRtcpFailure(Throwable e) {
        String message = "RTCP failure!";
        if (e != null) {
            message = message + " Reason: " + e.getMessage();
        }
        this.onRtcpFailure(message);
    }

    @Override
    public void setConnectionFailureListener(ConnectionFailureListener connectionFailureListener) {
        this.connectionFailureListener = connectionFailureListener;
    }

    @Override
    protected void onCreated() throws Exception {
        this.reset();
    }

    @Override
    protected void onFailed() {
        this.closeResources();
        if (this.connectionFailureListener != null) {
            this.connectionFailureListener.onFailure();
        }
    }

    @Override
    protected void onOpened() throws Exception {
    }

    @Override
    protected void onClosed() {
        this.closeResources();
        try {
            this.setMode(ConnectionMode.INACTIVE);
        }
        catch (ModeNotSupportedException e) {
            logger.warn((Object)"Could not set connection mode to INACTIVE.", (Throwable)e);
        }
        this.releaseConnection(ConnectionType.RTP);
        this.connectionFailureListener = null;
    }

    public long getBytesReceived() {
        return 0L;
    }

    public long getBytesTransmitted() {
        return 0L;
    }

    public double getJitter() {
        return 0.0;
    }

    public long getPacketsReceived() {
        return 0L;
    }

    public long getPacketsTransmitted() {
        return 0L;
    }

    public AudioChannel getAudioChannel() {
        return this.audioChannel;
    }
}

