/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.net.URI;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.Configuration;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.joda.time.DateTime;
import org.mobicents.servlet.sip.restcomm.util.StringUtils;
import org.restcomm.sbc.bo.Account;
import org.restcomm.sbc.bo.AccountList;
import org.restcomm.sbc.bo.RestCommResponse;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.rest.SecuredEndpoint;
import org.restcomm.sbc.rest.converter.AccountConverter;
import org.restcomm.sbc.rest.converter.AccountListConverter;
import org.restcomm.sbc.rest.converter.RestCommResponseConverter;
import org.restcomm.sbc.rest.exceptions.InsufficientPermission;

public abstract class AccountsEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected Gson gson;
    protected XStream xstream;

    @PostConstruct
    private void init() {
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        super.init(this.configuration);
        AccountConverter converter = new AccountConverter(this.configuration);
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Account.class, (Object)converter);
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new AccountListConverter(this.configuration));
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.checkAuthenticatedAccount();
    }

    private Account createFrom(Sid accountSid, MultivaluedMap<String, String> data) {
        this.validate(data);
        DateTime now = DateTime.now();
        String emailAddress = ((String)data.getFirst((Object)"EmailAddress")).toLowerCase();
        Sid sid = Sid.generate(Sid.Type.ACCOUNT, emailAddress);
        String friendlyName = emailAddress;
        if (data.containsKey((Object)"FriendlyName")) {
            friendlyName = (String)data.getFirst((Object)"FriendlyName");
        }
        Account.Type type = Account.Type.FULL;
        Account.Status status = Account.Status.ACTIVE;
        if (data.containsKey((Object)"Status")) {
            status = Account.Status.valueOf((String)data.getFirst((Object)"Status"));
        }
        String password = (String)data.getFirst((Object)"Password");
        String authToken = new Md5Hash((Object)password).toString();
        String role = (String)data.getFirst((Object)"Role");
        String rootUri = this.configuration.getString("root-uri");
        rootUri = StringUtils.addSuffixIfNotPresent((String)rootUri, (String)"/");
        StringBuilder buffer = new StringBuilder();
        buffer.append(rootUri).append(this.getApiVersion(null)).append("/Accounts/").append(sid.toString());
        URI uri = URI.create(buffer.toString());
        return new Account(sid, now, now, emailAddress, friendlyName, accountSid, type, status, authToken, role, uri);
    }

    protected Response getAccount(String accountSid, MediaType responseType) {
        Account account = null;
        this.checkPermission("RestComm:Read:Accounts");
        if (Sid.pattern.matcher(accountSid).matches()) {
            try {
                account = this.accountsDao.getAccount(new Sid(accountSid));
            }
            catch (Exception e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }
        try {
            account = this.accountsDao.getAccount(accountSid);
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(account, "RestComm:Read:Accounts", SecuredEndpoint.SecuredType.SECURED_ACCOUNT);
        if (account == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse(account);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)account), (String)"application/json").build();
        }
        return null;
    }

    protected Response deleteAccount(String operatedSid) {
        this.checkPermission("RestComm:Delete:Accounts");
        Sid accountSid = this.userIdentityContext.getEffectiveAccount().getSid();
        Sid sidToBeRemoved = new Sid(operatedSid);
        Account removedAccount = this.accountsDao.getAccount(sidToBeRemoved);
        this.secure(removedAccount, "RestComm:Delete:Accounts", SecuredEndpoint.SecuredType.SECURED_ACCOUNT);
        if (operatedSid.equalsIgnoreCase(accountSid.toString())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (this.accountsDao.getAccount(sidToBeRemoved) == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.accountsDao.removeAccount(sidToBeRemoved);
        return Response.ok().build();
    }

    protected Response getAccounts(MediaType responseType) {
        this.checkPermission("RestComm:Read:Accounts");
        Account account = this.userIdentityContext.getEffectiveAccount();
        if (account == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        ArrayList<Account> accounts = new ArrayList<Account>();
        accounts.add(account);
        accounts.addAll(this.accountsDao.getAccounts(account.getSid()));
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse(new AccountList(accounts));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson(accounts), (String)"application/json").build();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Response putAccount(MultivaluedMap<String, String> data, MediaType responseType) {
        this.checkPermission("RestComm:Create:Accounts");
        Sid sid = this.userIdentityContext.getEffectiveAccount().getSid();
        Account account = null;
        try {
            account = this.createFrom(sid, data);
        }
        catch (NullPointerException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        if (this.accountsDao.getAccount(account.getSid()) != null || account.getEmailAddress().equalsIgnoreCase("administrator@company.com")) return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"The email address used for the new account is already in use.").build();
        Account parent = this.accountsDao.getAccount(sid);
        if (!parent.getStatus().equals((Object)Account.Status.ACTIVE) || !this.isSecuredByPermission("RestComm:Create:Accounts")) throw new InsufficientPermission();
        if (!this.hasAccountRole(this.getAdministratorRole()) || !data.containsKey((Object)"Role")) {
            account = account.setRole(parent.getRole());
        }
        this.accountsDao.addAccount(account);
        MultivaluedMapImpl clientData = new MultivaluedMapImpl();
        String username = ((String)data.getFirst((Object)"EmailAddress")).split("@")[0];
        clientData.add((Object)"Login", (Object)username);
        clientData.add((Object)"Password", data.getFirst((Object)"Password"));
        clientData.add((Object)"FriendlyName", (Object)account.getFriendlyName());
        clientData.add((Object)"AccountSid", (Object)account.getSid().toString());
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)account), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE != responseType) return null;
        RestCommResponse response = new RestCommResponse(account);
        return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
    }

    private Account update(Account account, MultivaluedMap<String, String> data) {
        Account result = account;
        if (data.containsKey((Object)"FriendlyName")) {
            result = result.setFriendlyName((String)data.getFirst((Object)"FriendlyName"));
        }
        result = data.containsKey((Object)"Status") ? result.setStatus(Account.Status.getValueOf((String)data.getFirst((Object)"Status"))) : result.setStatus(Account.Status.ACTIVE);
        if (data.containsKey((Object)"Password")) {
            String hash = new Md5Hash(data.getFirst((Object)"Password")).toString();
            result = result.setAuthToken(hash);
        }
        if (data.containsKey((Object)"Auth_Token")) {
            result = result.setAuthToken((String)data.getFirst((Object)"Auth_Token"));
        }
        return result;
    }

    protected Response updateAccount(String accountSid, MultivaluedMap<String, String> data, MediaType responseType) {
        this.checkPermission("RestComm:Modify:Accounts");
        Sid sid = new Sid(accountSid);
        Account account = this.accountsDao.getAccount(sid);
        if (account == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        account = this.update(account, data);
        this.secure(account, "RestComm:Modify:Accounts", SecuredEndpoint.SecuredType.SECURED_ACCOUNT);
        this.accountsDao.updateAccount(account);
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)account), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse(account);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    private void validate(MultivaluedMap<String, String> data) throws NullPointerException {
        if (!data.containsKey((Object)"EmailAddress")) {
            throw new NullPointerException("Email address can not be null.");
        }
        if (!data.containsKey((Object)"Password")) {
            throw new NullPointerException("Password can not be null.");
        }
    }
}

