/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.NotThreadSafe;
import org.restcomm.sbc.bo.Account;
import org.restcomm.sbc.bo.RestCommResponse;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.bo.Statistics;
import org.restcomm.sbc.bo.StatisticsList;
import org.restcomm.sbc.configuration.RestcommConfiguration;
import org.restcomm.sbc.dao.AccountsDao;
import org.restcomm.sbc.dao.DaoManager;
import org.restcomm.sbc.dao.StatisticsDao;
import org.restcomm.sbc.rest.SecuredEndpoint;
import org.restcomm.sbc.rest.converter.RestCommResponseConverter;
import org.restcomm.sbc.rest.converter.StatisticsConverter;
import org.restcomm.sbc.rest.converter.StatisticsListConverter;

@NotThreadSafe
public abstract class StatisticsEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected DaoManager daos;
    protected Gson gson;
    protected GsonBuilder builder;
    protected XStream xstream;
    protected AccountsDao accountsDao;
    protected String instanceId;
    protected StatisticsListConverter listConverter;

    @PostConstruct
    public void init() {
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        this.daos = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.accountsDao = this.daos.getAccountsDao();
        super.init(this.configuration);
        this.listConverter = new StatisticsListConverter(this.configuration);
        StatisticsConverter converter = new StatisticsConverter(this.configuration);
        this.builder = new GsonBuilder();
        this.builder.registerTypeAdapter(Statistics.class, (Object)converter);
        this.builder.registerTypeAdapter(StatisticsList.class, (Object)this.listConverter);
        this.builder.setPrettyPrinting();
        this.gson = this.builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.xstream.registerConverter((Converter)this.listConverter);
        this.instanceId = RestcommConfiguration.getInstance().getMain().getInstanceId();
    }

    protected Response getStatistics(Sid sid, MediaType responseType) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Read:Statistics");
        StatisticsDao dao = this.daos.getStatisticsDao();
        Statistics route = dao.getRecord(sid);
        if (route == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(account, account.getSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse(route);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)route), (String)"application/json").build();
        }
        return null;
    }

    protected Response deleteStatistics(Sid sid) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Delete:Statistics", SecuredEndpoint.SecuredType.SECURED_ACCOUNT);
        StatisticsDao dao = this.daos.getStatisticsDao();
        Statistics route = dao.getRecord(sid);
        if (route == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        dao.removeRecord(sid);
        return Response.ok().build();
    }

    protected Response getStatistics(UriInfo info, MediaType responseType) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Read:Statistics");
        StatisticsDao dao = this.daos.getStatisticsDao();
        List<Statistics> routes = dao.getRecords();
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse(new StatisticsList(routes));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)new StatisticsList(routes)), (String)"application/json").build();
        }
        return null;
    }

    private Statistics createFrom(String accountSid, MultivaluedMap<String, String> data) {
        Statistics.Builder builder = Statistics.builder();
        int mem_usage = Integer.parseInt((String)data.getFirst((Object)"MemoryUsage"));
        int cpu_usage = Integer.parseInt((String)data.getFirst((Object)"CpuUsage"));
        int rejected = Integer.parseInt((String)data.getFirst((Object)"CallsRejected"));
        int live = Integer.parseInt((String)data.getFirst((Object)"LiveCalls"));
        int threats = Integer.parseInt((String)data.getFirst((Object)"Threats"));
        double rate = Double.parseDouble((String)data.getFirst((Object)"CallRate"));
        builder.setCallRate(rate);
        builder.setCallRejectedCount(rejected);
        builder.setCpuUsage(cpu_usage);
        builder.setLiveCallsCount(live);
        builder.setMemoryUsage(mem_usage);
        builder.setThreatCount(threats);
        Sid sid = Sid.generate(Sid.Type.RANDOM);
        builder.setSid(sid);
        return builder.build();
    }

    protected Response putStatistics(MultivaluedMap<String, String> data, MediaType responseType) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Modify:Statistics");
        StatisticsDao dao = this.daos.getStatisticsDao();
        try {
            this.validate(data);
        }
        catch (RuntimeException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        Statistics route = this.createFrom(account.getSid().toString(), data);
        dao.addRecord(route);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse(route);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)route), (String)"application/json").build();
        }
        return null;
    }

    private void validate(MultivaluedMap<String, String> data) {
    }
}

