/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import java.text.ParseException;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.configuration.Configuration;
import org.mobicents.servlet.sip.restcomm.annotations.concurrency.NotThreadSafe;
import org.restcomm.sbc.bo.Account;
import org.restcomm.sbc.bo.BanList;
import org.restcomm.sbc.bo.BanListFilter;
import org.restcomm.sbc.bo.BanListList;
import org.restcomm.sbc.bo.RestCommResponse;
import org.restcomm.sbc.bo.Sid;
import org.restcomm.sbc.configuration.RestcommConfiguration;
import org.restcomm.sbc.dao.AccountsDao;
import org.restcomm.sbc.dao.DaoManager;
import org.restcomm.sbc.dao.WhiteListDao;
import org.restcomm.sbc.managers.Monitor;
import org.restcomm.sbc.rest.SecuredEndpoint;
import org.restcomm.sbc.rest.converter.BanListConverter;
import org.restcomm.sbc.rest.converter.BanListListConverter;
import org.restcomm.sbc.rest.converter.RestCommResponseConverter;

@NotThreadSafe
public abstract class WhiteListsEndpoint
extends SecuredEndpoint {
    @Context
    protected ServletContext context;
    protected Configuration configuration;
    protected DaoManager daos;
    protected Gson gson;
    protected GsonBuilder builder;
    protected XStream xstream;
    protected BanListListConverter listConverter;
    protected AccountsDao accountsDao;
    protected String instanceId;

    @PostConstruct
    public void init() {
        this.configuration = (Configuration)this.context.getAttribute(Configuration.class.getName());
        this.configuration = this.configuration.subset("runtime-settings");
        this.daos = (DaoManager)this.context.getAttribute(DaoManager.class.getName());
        this.accountsDao = this.daos.getAccountsDao();
        super.init(this.configuration);
        BanListConverter converter = new BanListConverter(BanList.Type.WHITE, this.configuration);
        this.listConverter = new BanListListConverter(this.configuration);
        this.builder = new GsonBuilder();
        this.builder.registerTypeAdapter(BanList.class, (Object)converter);
        this.builder.registerTypeAdapter(BanListList.class, (Object)this.listConverter);
        this.builder.setPrettyPrinting();
        this.gson = this.builder.create();
        this.xstream = new XStream();
        this.xstream.alias("RestcommResponse", RestCommResponse.class);
        this.xstream.registerConverter((Converter)converter);
        this.xstream.registerConverter((Converter)new RestCommResponseConverter(this.configuration));
        this.xstream.registerConverter((Converter)this.listConverter);
        this.instanceId = RestcommConfiguration.getInstance().getMain().getInstanceId();
    }

    protected Response getBanList(String ipAddress, MediaType responseType) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Read:BanLists");
        WhiteListDao dao = this.daos.getWhiteListDao();
        BanList banList = dao.getBanList(ipAddress);
        if (banList == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(account, account.getSid(), SecuredEndpoint.SecuredType.SECURED_STANDARD);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse(banList);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)banList), (String)"application/json").build();
        }
        return null;
    }

    protected Response deleteBanList(String ipAddress) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Delete:BanLists", SecuredEndpoint.SecuredType.SECURED_ACCOUNT);
        WhiteListDao dao = this.daos.getWhiteListDao();
        BanList banList = dao.getBanList(ipAddress);
        if (banList == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        dao.removeBanList(banList);
        return Response.ok().build();
    }

    private BanList update(BanList banList, MultivaluedMap<String, String> data) {
        BanList result = banList;
        if (data.containsKey((Object)"IpAddress")) {
            result = result.setIpAddress((String)data.getFirst((Object)"IpAddress"));
        }
        return result;
    }

    protected Response updateBanList(String ipAddress) {
        this.checkPermission("RestComm:Delete:BanLists");
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Delete:BanLists", SecuredEndpoint.SecuredType.SECURED_ACCOUNT);
        WhiteListDao dao = this.daos.getWhiteListDao();
        BanList banList = dao.getBanList(ipAddress);
        if (banList == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        banList = banList.setAction(Monitor.Action.REMOVE);
        dao.updateBanList(banList);
        return Response.ok().build();
    }

    protected Response updateBanList(String ipAddress, MultivaluedMap<String, String> data, MediaType responseType) {
        this.checkPermission("RestComm:Modify:BanLists");
        Account account = this.userIdentityContext.getEffectiveAccount();
        if (account == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        this.secure(account, "RestComm:Modify:BanLists", SecuredEndpoint.SecuredType.SECURED_ACCOUNT);
        WhiteListDao dao = this.daos.getWhiteListDao();
        BanList banList = dao.getBanList(ipAddress);
        this.update(banList, data);
        dao.updateBanList(banList);
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)banList), (String)"application/json").build();
        }
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse(banList);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        return null;
    }

    protected Response getBanLists(UriInfo info, MediaType responseType) {
        BanListFilter filter;
        BanListFilter filterForTotal;
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Read:BanLists");
        boolean localInstanceOnly = true;
        try {
            String localOnly = (String)info.getQueryParameters().getFirst((Object)"localOnly");
            if (localOnly != null && localOnly.equalsIgnoreCase("false")) {
                localInstanceOnly = false;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String pageSize = (String)info.getQueryParameters().getFirst((Object)"PageSize");
        String page = (String)info.getQueryParameters().getFirst((Object)"Page");
        String ipAddress = (String)info.getQueryParameters().getFirst((Object)"IpAddress");
        String reason = (String)info.getQueryParameters().getFirst((Object)"Reason");
        String dateCreated = (String)info.getQueryParameters().getFirst((Object)"DateCreated");
        String dateExpires = (String)info.getQueryParameters().getFirst((Object)"DateExpires");
        String accountSid = (String)info.getQueryParameters().getFirst((Object)"AccountSid");
        String action = (String)info.getQueryParameters().getFirst((Object)"Action");
        if (pageSize == null) {
            pageSize = "50";
        }
        if (page == null) {
            page = "0";
        }
        int limit = Integer.parseInt(pageSize);
        int offset = page == "0" ? 0 : (Integer.parseInt(page) - 1) * Integer.parseInt(pageSize) + Integer.parseInt(pageSize);
        WhiteListDao dao = this.daos.getWhiteListDao();
        try {
            filterForTotal = localInstanceOnly ? new BanListFilter(BanList.Type.WHITE.toString(), ipAddress, accountSid, dateCreated, dateExpires, reason, action, limit, offset, null) : new BanListFilter(BanList.Type.WHITE.toString(), ipAddress, accountSid, dateCreated, dateExpires, reason, action, limit, offset, this.instanceId);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        int total = dao.getTotalBanLists(filterForTotal);
        if (Integer.parseInt(page) > total / limit) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            filter = localInstanceOnly ? new BanListFilter(BanList.Type.WHITE.toString(), ipAddress, accountSid, dateCreated, dateExpires, reason, action, limit, offset, null) : new BanListFilter(BanList.Type.WHITE.toString(), ipAddress, accountSid, dateCreated, dateExpires, reason, action, limit, offset, this.instanceId);
        }
        catch (ParseException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        List<BanList> banLists = dao.getBanLists(filter);
        this.listConverter.setCount(total);
        this.listConverter.setPage(Integer.parseInt(page));
        this.listConverter.setPageSize(Integer.parseInt(pageSize));
        this.listConverter.setPathUri(info.getRequestUri().getPath());
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse(new BanListList(banLists));
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)new BanListList(banLists)), (String)"application/json").build();
        }
        return null;
    }

    private BanList createFrom(String accountSid, MultivaluedMap<String, String> data) {
        BanList.Builder builder = BanList.builder();
        builder.setAccountSid(new Sid(accountSid));
        String ipAddress = (String)data.getFirst((Object)"IpAddress");
        builder.setipAddress(ipAddress);
        builder.setAction(Monitor.Action.APPLY);
        builder.setReason(BanList.Reason.ADMIN);
        return builder.build();
    }

    protected Response putBanList(MultivaluedMap<String, String> data, MediaType responseType) {
        Account account = this.userIdentityContext.getEffectiveAccount();
        this.secure(account, "RestComm:Modify:BanLists");
        WhiteListDao dao = this.daos.getWhiteListDao();
        try {
            this.validate(data);
        }
        catch (RuntimeException exception) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getMessage()).build();
        }
        BanList banList = this.createFrom(account.getSid().toString(), data);
        dao.addBanList(banList);
        if (MediaType.APPLICATION_XML_TYPE == responseType) {
            RestCommResponse response = new RestCommResponse(banList);
            return Response.ok((Object)this.xstream.toXML((Object)response), (String)"application/xml").build();
        }
        if (MediaType.APPLICATION_JSON_TYPE == responseType) {
            return Response.ok((Object)this.gson.toJson((Object)banList), (String)"application/json").build();
        }
        return null;
    }

    private void validate(MultivaluedMap<String, String> data) {
        if (!data.containsKey((Object)"IpAddress")) {
            throw new NullPointerException("IpAddress can not be null.");
        }
    }
}

