/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.sbc.servlet.sip;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.sip.SipFactory;
import javax.servlet.sip.SipServlet;
import javax.servlet.sip.SipServletMessage;
import javax.servlet.sip.SipServletRequest;
import javax.servlet.sip.SipServletResponse;
import org.apache.commons.configuration.Configuration;
import org.apache.log4j.Logger;
import org.restcomm.chain.processor.impl.SIPMutableMessage;
import org.restcomm.sbc.ConfigurationCache;
import org.restcomm.sbc.chain.impl.registrar.DownstreamRegistrarProcessorChain;
import org.restcomm.sbc.chain.impl.registrar.UpstreamRegistrarProcessorChain;

public class SBCRegistrarServlet
extends SipServlet {
    private static final long serialVersionUID = 1L;
    private Configuration configuration;
    private SipFactory sipFactory;
    private UpstreamRegistrarProcessorChain upChain;
    private DownstreamRegistrarProcessorChain dwChain;
    private ServletConfig config;
    private static transient Logger LOG = Logger.getLogger(SBCRegistrarServlet.class);

    public void init(ServletConfig servletConfig) throws ServletException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)">> Registrar Servlet init()");
        }
        super.init(servletConfig);
        this.config = servletConfig;
        this.sipFactory = (SipFactory)this.getServletContext().getAttribute("javax.servlet.sip.SipFactory");
        ServletContext context = servletConfig.getServletContext();
        this.configuration = (Configuration)context.getAttribute(Configuration.class.getName());
        ConfigurationCache.build(this.sipFactory, this.configuration);
        this.upChain = new UpstreamRegistrarProcessorChain();
        LOG.info((Object)("Loading (v. " + this.upChain.getVersion() + ") " + this.upChain.getName()));
        this.dwChain = new DownstreamRegistrarProcessorChain();
        LOG.info((Object)("Loading (v. " + this.dwChain.getVersion() + ") " + this.dwChain.getName()));
    }

    protected void doRegister(SipServletRequest sipServletRequest) throws ServletException, IOException {
        LOG.info((Object)("OUTB IFCES=" + this.config.getServletContext().getAttribute("javax.servlet.sip.outboundInterfaces")));
        this.upChain.process(new SIPMutableMessage((SipServletMessage)sipServletRequest));
    }

    protected void doResponse(SipServletResponse sipServletResponse) throws ServletException, IOException {
        this.dwChain.process(new SIPMutableMessage((SipServletMessage)sipServletResponse));
        super.doResponse(sipServletResponse);
    }

    protected void doErrorResponse(SipServletResponse sipServletResponse) throws ServletException, IOException {
    }
}

