/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.local;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Preference;
import org.restlet.data.Reference;
import org.restlet.data.ReferenceList;
import org.restlet.data.Status;
import org.restlet.engine.local.Entity;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Directory;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;

public class DirectoryServerResource
extends ServerResource {
    private volatile List<Variant> variantsGet;
    private volatile String baseName;
    private volatile Variant baseVariant;
    private volatile Directory directory;
    private volatile ReferenceList directoryContent;
    private volatile boolean directoryRedirection;
    private volatile boolean directoryTarget;
    private volatile String directoryUri;
    private volatile Representation fileContent;
    private volatile boolean fileTarget;
    private volatile boolean indexTarget;
    private volatile Reference originalRef;
    private volatile Variant protoVariant;
    private volatile String relativePart;
    private volatile String targetUri;
    private volatile Reference uniqueReference;

    @Override
    public Representation delete() throws ResourceException {
        if (this.directory.isModifiable()) {
            Request contextRequest = new Request(Method.DELETE, this.targetUri);
            Response contextResponse = new Response(contextRequest);
            if (this.directoryTarget && !this.indexTarget) {
                contextRequest.setResourceRef(this.targetUri);
                this.getClientDispatcher().handle(contextRequest, contextResponse);
            } else {
                ReferenceList references = this.getVariantsReferences();
                if (!references.isEmpty()) {
                    if (this.uniqueReference != null) {
                        contextRequest.setResourceRef(this.uniqueReference);
                        this.getClientDispatcher().handle(contextRequest, contextResponse);
                    } else {
                        contextResponse.setStatus(new Status(Status.CLIENT_ERROR_NOT_ACCEPTABLE, "Unable to process properly the request. Several variants exist but none of them suits precisely. "));
                    }
                } else {
                    contextResponse.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                }
            }
            this.setStatus(contextResponse.getStatus());
        } else {
            this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED, "The directory is not modifiable.");
        }
        return null;
    }

    @Override
    public void doInit() throws ResourceException {
        try {
            this.directory = (Directory)this.getRequestAttributes().get("org.restlet.directory");
            this.relativePart = this.getReference().getRemainingPart(false, false);
            this.setNegotiated(this.directory.isNegotiatingContent());
            if (this.getApplication() != null && this.getApplication().getTunnelService().isExtensionsTunnel()) {
                this.originalRef = this.getOriginalRef();
                if (this.originalRef != null) {
                    this.originalRef.setBaseRef(this.getReference().getBaseRef());
                    this.relativePart = this.originalRef.getRemainingPart();
                }
            }
            if (this.relativePart.startsWith("/")) {
                this.relativePart = this.relativePart.substring(1);
            }
            this.targetUri = new Reference(this.directory.getRootRef().toString() + this.relativePart).toString(false, false);
            this.preventUpperDirectoryAccess();
            if (this.getClientDispatcher() == null) {
                this.getLogger().warning("No client dispatcher is available on the context. Can't get the target URI: " + this.targetUri);
            } else {
                int index;
                Response contextResponse = this.getRepresentation(this.targetUri);
                if (contextResponse.getEntity() != null) {
                    if (MediaType.TEXT_URI_LIST.equals(contextResponse.getEntity().getMediaType())) {
                        this.directoryTarget = true;
                        this.fileTarget = false;
                        this.directoryContent = new ReferenceList(contextResponse.getEntity());
                        if (!this.getReference().getPath().endsWith("/")) {
                            this.directoryRedirection = true;
                        }
                        if (!this.targetUri.endsWith("/")) {
                            this.targetUri = this.targetUri + "/";
                            this.relativePart = this.relativePart + "/";
                        }
                        if (this.getDirectory().getIndexName() != null && this.getDirectory().getIndexName().length() > 0) {
                            this.directoryUri = this.targetUri;
                            this.baseName = this.getDirectory().getIndexName();
                            this.targetUri = this.directoryUri + this.baseName;
                            this.indexTarget = true;
                        } else {
                            this.directoryUri = this.targetUri;
                            this.baseName = null;
                        }
                    } else {
                        this.directoryTarget = false;
                        this.fileTarget = true;
                        this.fileContent = contextResponse.getEntity();
                    }
                } else {
                    this.directoryTarget = false;
                    this.fileTarget = false;
                    if (this.targetUri.endsWith("/")) {
                        if (this.getDirectory().getIndexName() != null && this.getDirectory().getIndexName().length() > 0) {
                            this.directoryUri = this.targetUri;
                            this.directoryTarget = true;
                            contextResponse = this.getRepresentation(this.directoryUri + this.getDirectory().getIndexName());
                            if (contextResponse.getEntity() != null) {
                                this.baseName = this.getDirectory().getIndexName();
                                this.targetUri = this.directoryUri + this.baseName;
                                this.directoryContent = new ReferenceList();
                                this.directoryContent.add(new Reference(this.targetUri));
                                this.indexTarget = true;
                            }
                        }
                    } else if (this.getDirectory().getIndexName() != null && this.getDirectory().getIndexName().length() > 0 && (contextResponse = this.getRepresentation(this.targetUri + "/" + this.getDirectory().getIndexName())).getEntity() != null) {
                        this.directoryUri = this.targetUri + "/";
                        this.baseName = this.getDirectory().getIndexName();
                        this.targetUri = this.directoryUri + this.baseName;
                        this.directoryTarget = true;
                        this.directoryRedirection = true;
                        this.directoryContent = new ReferenceList();
                        this.directoryContent.add(new Reference(this.targetUri));
                        this.indexTarget = true;
                    }
                }
                if (this.isNegotiated() && !this.directoryTarget && !this.fileTarget && this.originalRef != null) {
                    this.relativePart = this.getReference().getRemainingPart();
                    this.targetUri = new Reference(this.directory.getRootRef().toString() + this.relativePart).normalize().toString(false, false);
                    if (!this.targetUri.startsWith(this.directory.getRootRef().toString())) {
                        this.targetUri = this.directory.getRootRef().toString();
                    }
                }
                if (!this.fileTarget || this.fileContent == null || !this.getRequest().getMethod().isSafe()) {
                    List<Variant> variants;
                    if (!this.directoryTarget) {
                        int lastSlashIndex = this.targetUri.lastIndexOf(47);
                        if (lastSlashIndex == -1) {
                            this.directoryUri = "";
                            this.baseName = this.targetUri;
                        } else {
                            this.directoryUri = this.targetUri.substring(0, lastSlashIndex + 1);
                            this.baseName = this.targetUri.substring(lastSlashIndex + 1);
                        }
                        contextResponse = this.getRepresentation(this.directoryUri);
                        if (contextResponse.getEntity() != null && MediaType.TEXT_URI_LIST.equals(contextResponse.getEntity().getMediaType())) {
                            this.directoryContent = new ReferenceList(contextResponse.getEntity());
                        }
                    }
                    if (this.baseName != null) {
                        this.baseVariant = new Variant();
                        Entity.updateMetadata(this.baseName, this.baseVariant, true, this.getMetadataService());
                        this.protoVariant = new Variant();
                        Entity.updateMetadata(this.baseName, this.protoVariant, false, this.getMetadataService());
                        this.baseName = Entity.getBaseName(this.baseName, this.getMetadataService());
                    }
                    if ((variants = this.getVariants(Method.GET)) == null || variants.isEmpty()) {
                        this.setExisting(false);
                    }
                }
                if (this.isExisting() && !this.directory.isDeeplyAccessible() && (index = this.relativePart.indexOf("/")) != -1) {
                    this.setExisting((index = this.relativePart.indexOf("/", index)) == -1);
                }
            }
            this.getLogger().fine("Converted target URI: " + this.targetUri);
            this.getLogger().fine("Converted base name : " + this.baseName);
        }
        catch (IOException ioe) {
            throw new ResourceException(ioe);
        }
    }

    public void preventUpperDirectoryAccess() {
        String targetUriPath = new Reference(Reference.decode(this.targetUri)).normalize().toString();
        if (!targetUriPath.startsWith(this.directory.getRootRef().toString())) {
            throw new ResourceException(Status.CLIENT_ERROR_FORBIDDEN);
        }
    }

    @Override
    protected Representation get() throws ResourceException {
        Representation result = null;
        List<Variant> variants = this.getVariants(Method.GET);
        if (variants == null || variants.isEmpty()) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        } else if (variants.size() == 1) {
            result = (Representation)variants.get(0);
        } else {
            ReferenceList variantRefs = new ReferenceList();
            for (Variant variant : variants) {
                if (variant.getLocationRef() != null) {
                    variantRefs.add(variant.getLocationRef());
                    continue;
                }
                this.getLogger().warning("A resource with multiple variants should provide a location for each variant when content negotiation is turned off");
            }
            if (!variantRefs.isEmpty()) {
                this.setStatus(Status.REDIRECTION_MULTIPLE_CHOICES);
                result = variantRefs.getTextRepresentation();
            } else {
                this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
        }
        return result;
    }

    public String getBaseName() {
        return this.baseName;
    }

    protected Restlet getClientDispatcher() {
        return this.getDirectory().getContext() == null ? null : this.getDirectory().getContext().getClientDispatcher();
    }

    public Directory getDirectory() {
        return this.directory;
    }

    protected ReferenceList getDirectoryContent() {
        return this.directoryContent;
    }

    public String getDirectoryUri() {
        return this.directoryUri;
    }

    private Response getRepresentation(String resourceUri) {
        return this.getClientDispatcher().handle(new Request(Method.GET, resourceUri));
    }

    protected Response getRepresentation(String resourceUri, MediaType acceptedMediaType) {
        if (acceptedMediaType == null) {
            return this.getClientDispatcher().handle(new Request(Method.GET, resourceUri));
        }
        Request request = new Request(Method.GET, resourceUri);
        request.getClientInfo().getAcceptedMediaTypes().add(new Preference<MediaType>(acceptedMediaType));
        return this.getClientDispatcher().handle(request);
    }

    private Comparator<Representation> getRepresentationsComparator() {
        Comparator<Representation> identifiersComparator = new Comparator<Representation>(){

            @Override
            public int compare(Representation rep0, Representation rep1) {
                boolean bRep1Null;
                boolean bRep0Null = rep0.getLocationRef() == null;
                boolean bl = bRep1Null = rep1.getLocationRef() == null;
                if (bRep0Null && bRep1Null) {
                    return 0;
                }
                if (bRep0Null) {
                    return -1;
                }
                if (bRep1Null) {
                    return 1;
                }
                return rep0.getLocationRef().getLastSegment().compareTo(rep1.getLocationRef().getLastSegment());
            }
        };
        return identifiersComparator;
    }

    public String getTargetUri() {
        return this.targetUri;
    }

    @Override
    public List<Variant> getVariants() {
        return this.getVariants(this.getMethod());
    }

    @Override
    protected List<Variant> getVariants(Method method) {
        List<Variant> result = null;
        if (Method.GET.equals(method) || Method.HEAD.equals(method)) {
            if (this.variantsGet != null) {
                result = this.variantsGet;
            } else {
                this.getLogger().fine("Getting variants for: " + this.getTargetUri());
                if (this.directoryContent != null && this.getReference() != null && this.getReference().getBaseRef() != null) {
                    int lastIndex;
                    TreeSet<Representation> resultSet = new TreeSet<Representation>(this.getRepresentationsComparator());
                    String baseRef = this.getReference().getBaseRef().toString(false, false);
                    if (!baseRef.endsWith("/")) {
                        baseRef = baseRef + "/";
                    }
                    if ((lastIndex = this.relativePart.lastIndexOf("/")) != -1) {
                        baseRef = baseRef + this.relativePart.substring(0, lastIndex);
                    }
                    int rootLength = this.getDirectoryUri().length();
                    if (this.baseName != null) {
                        for (Reference ref : this.getVariantsReferences()) {
                            Response contextResponse = this.getRepresentation(ref.toString());
                            if (!contextResponse.getStatus().isSuccess() || contextResponse.getEntity() == null) continue;
                            String filePath = ref.toString(false, false).substring(rootLength);
                            Representation rep = contextResponse.getEntity();
                            if (filePath.startsWith("/")) {
                                rep.setLocationRef(baseRef + filePath);
                            } else {
                                rep.setLocationRef(baseRef + "/" + filePath);
                            }
                            resultSet.add(rep);
                        }
                    }
                    if (!resultSet.isEmpty()) {
                        result = new ArrayList<Representation>(resultSet);
                    }
                    if (resultSet.isEmpty() && this.directoryTarget && this.getDirectory().isListingAllowed()) {
                        ReferenceList userList = new ReferenceList(this.directoryContent.size());
                        userList.setIdentifier(baseRef);
                        TreeSet<Reference> sortedSet = new TreeSet<Reference>(this.getDirectory().getComparator());
                        sortedSet.addAll(this.directoryContent);
                        for (Reference ref : sortedSet) {
                            String filePart = ref.toString(false, false).substring(rootLength);
                            StringBuilder filePath = new StringBuilder();
                            if (!baseRef.endsWith("/") && !filePart.startsWith("/")) {
                                filePath.append('/');
                            }
                            filePath.append(filePart);
                            userList.add(baseRef + filePath);
                        }
                        List<Variant> list = this.getDirectory().getIndexVariants(userList);
                        for (Variant variant : list) {
                            if (result == null) {
                                result = new ArrayList<Variant>();
                            }
                            result.add(this.getDirectory().getIndexRepresentation(variant, userList));
                        }
                    }
                } else if (this.fileTarget && this.fileContent != null) {
                    if (this.getOriginalRef() != null) {
                        this.fileContent.setLocationRef(this.getRequest().getOriginalRef());
                    } else {
                        this.fileContent.setLocationRef(this.getReference());
                    }
                    result = new ArrayList<Variant>();
                    result.add(this.fileContent);
                }
                this.variantsGet = result;
            }
        }
        return result;
    }

    private ReferenceList getVariantsReferences() {
        ReferenceList result = new ReferenceList(0);
        try {
            this.uniqueReference = null;
            Response contextResponse = this.getRepresentation(this.targetUri, MediaType.TEXT_URI_LIST);
            if (contextResponse.getEntity() != null) {
                if (MediaType.TEXT_URI_LIST.equals(contextResponse.getEntity().getMediaType())) {
                    ReferenceList listVariants = new ReferenceList(contextResponse.getEntity());
                    for (Reference ref : listVariants) {
                        String fullEntryName;
                        String entryUri = ref.toString();
                        int lastSlashIndex = entryUri.lastIndexOf(47);
                        String baseEntryName = fullEntryName = lastSlashIndex == -1 ? entryUri : entryUri.substring(lastSlashIndex + 1);
                        int firstDotIndex = fullEntryName.indexOf(46);
                        if (firstDotIndex != -1) {
                            baseEntryName = fullEntryName.substring(0, firstDotIndex);
                        }
                        if (!baseEntryName.equals(this.baseName)) continue;
                        Variant variant = new Variant();
                        Entity.updateMetadata(fullEntryName, variant, true, this.getMetadataService());
                        if (this.protoVariant.includes(variant)) {
                            result.add(ref);
                        }
                        if (!this.baseVariant.equals(variant)) continue;
                        this.uniqueReference = ref;
                    }
                } else {
                    result.add(contextResponse.getEntity().getLocationRef());
                }
            }
        }
        catch (IOException ioe) {
            this.getLogger().log(Level.WARNING, "Unable to get resource variants", ioe);
        }
        return result;
    }

    @Override
    public Representation handle() {
        Representation result = null;
        if (this.directoryRedirection) {
            if (this.originalRef != null) {
                if (this.originalRef.hasQuery()) {
                    this.redirectSeeOther(this.originalRef.getPath() + "/?" + this.originalRef.getQuery());
                } else {
                    this.redirectSeeOther(this.originalRef.getPath() + "/");
                }
            } else if (this.getReference().hasQuery()) {
                this.redirectSeeOther(this.getReference().getPath() + "/?" + this.getReference().getQuery());
            } else {
                this.redirectSeeOther(this.getReference().getPath() + "/");
            }
        } else {
            result = super.handle();
        }
        return result;
    }

    public boolean isDirectoryTarget() {
        return this.directoryTarget;
    }

    public boolean isFileTarget() {
        return this.fileTarget;
    }

    @Override
    public Representation put(Representation entity) throws ResourceException {
        if (this.directory.isModifiable()) {
            Request contextRequest = new Request(Method.PUT, this.targetUri);
            contextRequest.getRanges().addAll(this.getRanges());
            contextRequest.setEntity(entity);
            Response contextResponse = new Response(contextRequest);
            contextRequest.setResourceRef(this.targetUri);
            this.getClientDispatcher().handle(contextRequest, contextResponse);
            this.setStatus(contextResponse.getStatus());
        } else {
            this.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED, "The directory is not modifiable.");
        }
        return null;
    }

    public void setTargetUri(String targetUri) {
        this.targetUri = targetUri;
    }
}

