/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.restlet.data.MediaType;
import org.restlet.resource.Variant;

public abstract class Representation
extends Variant {
    private boolean contentAvailable = true;
    private boolean contentTransient = false;

    public Representation() {
        this(null);
    }

    public Representation(MediaType mediaType) {
        super(mediaType);
    }

    public abstract ReadableByteChannel getChannel() throws IOException;

    public abstract InputStream getStream() throws IOException;

    public String getText() throws IOException {
        String result = null;
        if (this.isAvailable()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.write(baos);
            result = this.getCharacterSet() != null ? baos.toString(this.getCharacterSet().getName()) : baos.toString();
        }
        return result;
    }

    public boolean isAvailable() {
        return this.contentAvailable;
    }

    public boolean isTransient() {
        return this.contentTransient;
    }

    public void setAvailable(boolean available) {
        this.contentAvailable = available;
    }

    public void setTransient(boolean isTransient) {
        this.contentTransient = isTransient;
    }

    public abstract void write(OutputStream var1) throws IOException;

    public abstract void write(WritableByteChannel var1) throws IOException;
}

