/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.application;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.restlet.data.Range;
import org.restlet.engine.io.IoUtils;
import org.restlet.engine.io.RangeInputStream;
import org.restlet.representation.Representation;
import org.restlet.util.WrapperRepresentation;

public class RangeRepresentation
extends WrapperRepresentation {
    private volatile Range range;

    public RangeRepresentation(Representation wrappedRepresentation) {
        this(wrappedRepresentation, null);
    }

    public RangeRepresentation(Representation wrappedRepresentation, Range range) {
        super(wrappedRepresentation);
        if (wrappedRepresentation.getRange() != null) {
            throw new IllegalArgumentException("The wrapped representation must not have a range set.");
        }
        this.setRange(range);
    }

    @Override
    public long getAvailableSize() {
        return IoUtils.getAvailableSize(this);
    }

    @Override
    @Deprecated
    public ReadableByteChannel getChannel() throws IOException {
        return IoUtils.getChannel(this.getStream());
    }

    @Override
    public Range getRange() {
        return this.range;
    }

    @Override
    public Reader getReader() throws IOException {
        return IoUtils.getReader(this.getStream(), this.getCharacterSet());
    }

    @Override
    public InputStream getStream() throws IOException {
        return new RangeInputStream(super.getStream(), this.getSize(), this.getRange());
    }

    @Override
    public String getText() throws IOException {
        return IoUtils.getText(this);
    }

    @Override
    public void setRange(Range range) {
        this.range = range;
    }

    @Override
    public void write(Writer writer) throws IOException {
        OutputStream os = IoUtils.getStream(writer, this.getCharacterSet());
        this.write(os);
        os.flush();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        IoUtils.copy(this.getStream(), outputStream);
    }

    @Override
    @Deprecated
    public void write(WritableByteChannel writableChannel) throws IOException {
        OutputStream os = IoUtils.getStream(writableChannel);
        this.write(os);
        os.flush();
    }
}

