/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.local;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.restlet.data.Disposition;
import org.restlet.data.MediaType;
import org.restlet.engine.io.IoUtils;
import org.restlet.representation.StreamRepresentation;

public class ZipEntryRepresentation
extends StreamRepresentation {
    protected final ZipEntry entry;
    protected final ZipFile zipFile;

    public ZipEntryRepresentation(MediaType mediaType, ZipFile zipFile, ZipEntry entry, int timeToLive) {
        super(mediaType);
        this.zipFile = zipFile;
        this.entry = entry;
        Disposition disposition = new Disposition();
        disposition.setFilename(entry.getName());
        this.setDisposition(disposition);
        this.setSize(entry.getSize());
        this.setModificationDate(new Date(entry.getTime()));
        if (timeToLive == 0) {
            this.setExpirationDate(null);
        } else if (timeToLive > 0) {
            this.setExpirationDate(new Date(System.currentTimeMillis() + 1000L * (long)timeToLive));
        }
    }

    @Override
    public InputStream getStream() throws IOException {
        return this.zipFile.getInputStream(this.entry);
    }

    @Override
    public void release() {
        try {
            this.zipFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        IoUtils.copy(this.getStream(), outputStream);
    }
}

