/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.data.Metadata;

public final class Language
extends Metadata {
    public static final Language ALL = new Language("*", "All languages");
    public static final Language DEFAULT = new Language(Locale.getDefault().getLanguage());
    public static final Language ENGLISH = new Language("en", "English language");
    public static final Language ENGLISH_US = new Language("en-us", "English language in USA");
    public static final Language FRENCH = new Language("fr", "French language");
    public static final Language FRENCH_FRANCE = new Language("fr-fr", "French language in France");
    public static final Language SPANISH = new Language("es", "Spanish language");
    private volatile List<String> subTags = null;

    public static Language valueOf(String name) {
        Language result = null;
        if (name != null && !name.isEmpty()) {
            result = name.equalsIgnoreCase(ALL.getName()) ? ALL : (name.equalsIgnoreCase(ENGLISH.getName()) ? ENGLISH : (name.equalsIgnoreCase(ENGLISH_US.getName()) ? ENGLISH_US : (name.equalsIgnoreCase(FRENCH.getName()) ? FRENCH : (name.equalsIgnoreCase(FRENCH_FRANCE.getName()) ? FRENCH_FRANCE : (name.equalsIgnoreCase(SPANISH.getName()) ? SPANISH : new Language(name))))));
        }
        return result;
    }

    public Language(String name) {
        this(name, "Language or range of languages");
    }

    public Language(String name, String description) {
        super(name, description);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Language && this.getName().equalsIgnoreCase(((Language)object).getName());
    }

    @Override
    public Language getParent() {
        Language result = null;
        result = this.getSubTags() != null && !this.getSubTags().isEmpty() ? Language.valueOf(this.getPrimaryTag()) : (this.equals(ALL) ? null : ALL);
        return result;
    }

    public String getPrimaryTag() {
        int separator = this.getName().indexOf(45);
        if (separator == -1) {
            return this.getName();
        }
        return this.getName().substring(0, separator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getSubTags() {
        List<String> v = this.subTags;
        if (v == null) {
            Language language = this;
            synchronized (language) {
                v = this.subTags;
                if (v == null) {
                    String[] tags;
                    CopyOnWriteArrayList<String> tokens = new CopyOnWriteArrayList<String>();
                    if (this.getName() != null && (tags = this.getName().split("-")).length > 0) {
                        for (int i = 1; i < tags.length; ++i) {
                            tokens.add(tags[i]);
                        }
                    }
                    this.subTags = v = Collections.unmodifiableList(tokens);
                }
            }
        }
        return v;
    }

    @Override
    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().toLowerCase().hashCode();
    }

    @Override
    public boolean includes(Metadata included) {
        boolean result;
        boolean bl = result = this.equals(ALL) || included == null || this.equals(included);
        if (!result && included instanceof Language) {
            Language includedLanguage = (Language)included;
            if (this.getPrimaryTag().equals(includedLanguage.getPrimaryTag())) {
                if (this.getSubTags().equals(includedLanguage.getSubTags())) {
                    result = true;
                } else if (this.getSubTags().isEmpty()) {
                    result = true;
                }
            }
        }
        return result;
    }
}

