/**
 * Copyright 2005-2024 Qlik
 * 
 * The contents of this file is subject to the terms of the Apache 2.0 open
 * source license available at http://www.opensource.org/licenses/apache-2.0
 * 
 * Restlet is a registered trademark of QlikTech International AB.
 */

package org.restlet.resource;

/**
 * Marker interface for RESTful resource proxies. This allows you to retrieve
 * and manipulate the underlying {@link ClientResource} of a dynamic client
 * proxy generated by the {@link ClientResource#create(String, Class)} method
 * for example, or by {@link ClientResource#getChild(String, Class)}.
 * 
 * @author Jerome Louvel
 */
public interface ClientProxy {

	/**
	 * Returns the wrapped client resource.
	 * 
	 * @return The wrapped client resource.
	 */
	ClientResource getClientResource();

}
