/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.restlet.engine.Engine;

public final class Method
implements Comparable<Method> {
    private static final Map<String, Method> _methods = new ConcurrentHashMap<String, Method>();
    public static final Method ALL = new Method("*", "Pseudo-method use to match all methods.");
    private static final String BASE_HTTP = "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html";
    public static final Method CONNECT = new Method("CONNECT", "Used with a proxy that can dynamically switch to being a tunnel", "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.9", false, false);
    public static final Method DELETE = new Method("DELETE", "Requests that the origin server deletes the resource identified by the request URI", "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.7", false, true);
    public static final Method GET = new Method("GET", "Retrieves whatever information (in the form of an entity) that is identified by the request URI", "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.3", true, true);
    public static final Method HEAD = new Method("HEAD", "Identical to GET except that the server must not return a message body in the response", "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.4", true, true);
    public static final Method OPTIONS = new Method("OPTIONS", "Requests for information about the communication options available on the request/response chain identified by the URI", "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.2", true, true);
    public static final Method PATCH = new Method("PATCH", "Requests that the origin server applies partial modifications to the resource identified by the request URI", "http://tools.ietf.org/html/rfc5789", false, false);
    public static final Method POST = new Method("POST", "Requests that the origin server accepts the entity enclosed in the request as a new subordinate of the resource identified by the request URI", "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.5", false, false);
    public static final Method PUT = new Method("PUT", "Requests that the enclosed entity be stored under the supplied request URI", "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.6", false, true);
    public static final Method TRACE = new Method("TRACE", "Used to invoke a remote, application-layer loop-back of the request message", "http://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.8", true, true);
    private final String description;
    private volatile boolean idempotent;
    private volatile String name;
    private final boolean replying;
    private final boolean safe;
    private volatile String uri;

    public static void register(Method method) {
        String name;
        String string = name = method == null ? null : method.getName().toLowerCase();
        if (name != null && !name.isEmpty()) {
            _methods.put(name, method);
        }
    }

    public static void sort(List<Method> methods) {
        Collections.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                return m1.getName().compareTo(m2.getName());
            }
        });
    }

    public static Method valueOf(String name) {
        Method result = null;
        if (name != null && !name.isEmpty() && (result = _methods.get(name.toLowerCase())) == null) {
            result = new Method(name);
        }
        return result;
    }

    public Method(String name) {
        this(name, null);
    }

    public Method(String name, String description) {
        this(name, description, null, false, false);
    }

    public Method(String name, String description, String uri) {
        this(name, description, uri, false, false);
    }

    public Method(String name, String description, String uri, boolean safe, boolean idempotent) {
        this(name, description, uri, safe, idempotent, true);
    }

    public Method(String name, String description, String uri, boolean safe, boolean idempotent, boolean replying) {
        this.name = name;
        this.description = description;
        this.uri = uri;
        this.safe = safe;
        this.idempotent = idempotent;
        this.replying = replying;
    }

    @Override
    public int compareTo(Method o) {
        if (o != null) {
            return this.getName().compareTo(o.getName());
        }
        return 1;
    }

    public boolean equals(Object object) {
        return object instanceof Method && ((Method)object).getName().equals(this.getName());
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri;
    }

    public int hashCode() {
        return this.getName() == null ? 0 : this.getName().hashCode();
    }

    public boolean isIdempotent() {
        return this.idempotent;
    }

    public boolean isReplying() {
        return this.replying;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public String toString() {
        return this.getName();
    }

    static {
        Engine.getInstance();
    }
}

