/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.util.Arrays;
import java.util.List;
import org.restlet.Connector;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.engine.Engine;
import org.restlet.engine.RestletHelper;

public class Client
extends Connector {
    private final RestletHelper<Client> helper;

    public Client(Context context, List<Protocol> protocols) {
        this(context, protocols, null);
    }

    public Client(Context context, List<Protocol> protocols, String helperClass) {
        super(context, protocols);
        this.helper = protocols != null && !protocols.isEmpty() ? (Engine.getInstance() != null ? Engine.getInstance().createHelper(this, helperClass) : null) : null;
        if (context != null && this.helper != null) {
            context.getAttributes().put("org.restlet.engine.helper", this.helper);
        }
    }

    public Client(Context context, Protocol ... protocols) {
        this(context, protocols == null ? null : Arrays.asList(protocols), null);
    }

    public Client(List<Protocol> protocols) {
        this(null, protocols, null);
    }

    public Client(Protocol ... protocols) {
        this((Context)null, protocols);
    }

    public Client(String protocolName) {
        this(Protocol.valueOf(protocolName));
    }

    private RestletHelper<Client> getHelper() {
        return this.helper;
    }

    @Override
    public void handle(Request request, Response response) {
        super.handle(request, response);
        if (this.getHelper() != null) {
            this.getHelper().handle(request, response);
        } else {
            String sb = "No available client connector supports the required protocol: '" + request.getProtocol().getName() + "'. Please add the JAR of a matching connector to your classpath.";
            response.setStatus(Status.CONNECTOR_ERROR_INTERNAL, sb);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.getHelper() != null;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.isStopped()) {
            if (this.getHelper() != null) {
                this.getHelper().start();
            }
            super.start();
        }
    }

    @Override
    public synchronized void stop() throws Exception {
        if (this.isStarted()) {
            super.stop();
            if (this.getHelper() != null) {
                this.getHelper().stop();
            }
        }
    }
}

