/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.security.Principal;
import java.util.Arrays;
import java.util.Objects;
import org.restlet.Response;
import org.restlet.data.ChallengeMessage;
import org.restlet.data.ChallengeRequest;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Parameter;
import org.restlet.data.Reference;
import org.restlet.engine.security.AuthenticatorUtils;
import org.restlet.engine.util.SystemUtils;
import org.restlet.util.Series;

public final class ChallengeResponse
extends ChallengeMessage {
    private volatile String clientNonce;
    private volatile Reference digestRef;
    private volatile String identifier;
    private volatile String quality;
    private volatile char[] secret;
    private volatile String secretAlgorithm;
    private volatile int serverNonceCount;
    private volatile long timeIssued;

    public ChallengeResponse(ChallengeRequest challengeRequest, Response response, String identifier, char[] secret) {
        this(challengeRequest, response, identifier, secret, "NONE");
    }

    public ChallengeResponse(ChallengeRequest challengeRequest, Response response, String identifier, char[] secret, String secretAlgorithm) {
        this(challengeRequest.getScheme(), null, identifier, secret, secretAlgorithm, null, null, null, null, null, null, null, 0, 0L);
        AuthenticatorUtils.update(this, response.getRequest(), response);
    }

    public ChallengeResponse(ChallengeRequest challengeRequest, Response response, String identifier, String secret) {
        this(challengeRequest, response, identifier, secret.toCharArray(), "NONE");
    }

    public ChallengeResponse(ChallengeScheme scheme) {
        this(scheme, null, (char[])null);
    }

    public ChallengeResponse(ChallengeScheme scheme, Series<Parameter> parameters, String identifier, char[] secret, String secretAlgorithm, String realm, String quality, Reference digestRef, String digestAlgorithm, String opaque, String clientNonce, String serverNonce, int serverNonceCount, long timeIssued) {
        super(scheme, realm, parameters, digestAlgorithm, opaque, serverNonce);
        this.clientNonce = clientNonce;
        this.digestRef = digestRef;
        this.identifier = identifier;
        this.quality = quality;
        this.secret = secret;
        this.secretAlgorithm = secretAlgorithm;
        this.serverNonceCount = serverNonceCount;
        this.timeIssued = timeIssued;
    }

    public ChallengeResponse(ChallengeScheme scheme, String identifier, char[] secret) {
        this(scheme, identifier, secret, null);
    }

    public ChallengeResponse(ChallengeScheme scheme, String identifier, char[] secret, Series<Parameter> parameters) {
        this(scheme, parameters, identifier, secret, "NONE", null, null, null, null, null, null, null, 0, 0L);
    }

    public ChallengeResponse(ChallengeScheme scheme, String identifier, Series<Parameter> parameters) {
        this(scheme, identifier, null, parameters);
    }

    public ChallengeResponse(ChallengeScheme scheme, String identifier, String secret) {
        this(scheme, identifier, secret != null ? secret.toCharArray() : null);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ChallengeResponse)) {
            return false;
        }
        ChallengeResponse that = (ChallengeResponse)obj;
        if (!(Objects.equals(this.getRawValue(), that.getRawValue()) && Objects.equals(this.getIdentifier(), that.getIdentifier()) && Objects.equals(this.getScheme(), that.getScheme()))) {
            return false;
        }
        return Arrays.equals(this.getSecret(), that.getSecret());
    }

    public String getClientNonce() {
        return this.clientNonce;
    }

    public Reference getDigestRef() {
        return this.digestRef;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Principal getPrincipal() {
        return this::getIdentifier;
    }

    public String getQuality() {
        return this.quality;
    }

    public char[] getSecret() {
        return this.secret;
    }

    public String getSecretAlgorithm() {
        return this.secretAlgorithm;
    }

    public int getServerNonceCount() {
        return this.serverNonceCount;
    }

    public String getServerNonceCountAsHex() {
        return AuthenticatorUtils.formatNonceCount(this.getServerNonceCount());
    }

    public long getTimeIssued() {
        return this.timeIssued;
    }

    @Override
    public int hashCode() {
        return SystemUtils.hashCode(this.getScheme(), this.getIdentifier(), this.getRawValue());
    }

    public void setClientNonce(String clientNonce) {
        this.clientNonce = clientNonce;
    }

    public void setDigestRef(Reference digestRef) {
        this.digestRef = digestRef;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public void setQuality(String quality) {
        this.quality = quality;
    }

    public void setSecret(char[] secret) {
        this.secret = secret;
    }

    public void setSecret(String secret) {
        this.secret = secret == null ? null : secret.toCharArray();
    }

    public void setSecretAlgorithm(String secretDigestAlgorithm) {
        this.secretAlgorithm = secretDigestAlgorithm;
    }

    public void setServerNonceCount(int serverNonceCount) {
        this.serverNonceCount = serverNonceCount;
    }

    public void setTimeIssued(long timeIssued) {
        this.timeIssued = timeIssued;
    }
}

