/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.connector.JettyServerHelper;

public class HttpServerHelper
extends JettyServerHelper {
    public HttpServerHelper(Server server) {
        super(server);
        this.getProtocols().add(Protocol.HTTP);
    }

    @Override
    protected ConnectionFactory[] createConnectionFactories(HttpConfiguration configuration) {
        ConnectionFactory[] connectionFactoryArray;
        HttpTransportProtocol httpTransportProtocol = HttpTransportProtocol.fromName(this.getHttpTransportProtocol());
        switch (httpTransportProtocol.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ConnectionFactory[] connectionFactoryArray2 = new ConnectionFactory[1];
                connectionFactoryArray = connectionFactoryArray2;
                connectionFactoryArray2[0] = new HttpConnectionFactory(configuration);
                break;
            }
            case 1: {
                ConnectionFactory[] connectionFactoryArray3 = new ConnectionFactory[2];
                connectionFactoryArray3[0] = new HttpConnectionFactory(configuration);
                connectionFactoryArray = connectionFactoryArray3;
                connectionFactoryArray3[1] = new HTTP2CServerConnectionFactory(configuration);
            }
        }
        return connectionFactoryArray;
    }

    @Override
    protected List<Connector> createConnectors(org.eclipse.jetty.server.Server server) {
        return List.of(this.createServerConnector(server, this.createHttpConfiguration()));
    }

    public String getHttpTransportProtocol() {
        return this.getHelpedParameters().getFirstValue("http.transport.protocol", HttpTransportProtocol.HTTP1_1.name());
    }

    private static enum HttpTransportProtocol {
        HTTP1_1,
        HTTP2;


        static HttpTransportProtocol fromName(String name) {
            try {
                return HttpTransportProtocol.valueOf(name);
            }
            catch (IllegalArgumentException iae) {
                String supportedHttpTransportProtocols = Arrays.toString((Object[])HttpTransportProtocol.values());
                String errorMessage = String.format("'%s' is not one of the supported values: %s", name, supportedHttpTransportProtocols);
                throw new IllegalArgumentException(errorMessage);
            }
        }
    }
}

