/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.connector;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.http3.server.HTTP3ServerConnectionFactory;
import org.eclipse.jetty.quic.server.QuicServerConnector;
import org.eclipse.jetty.quic.server.ServerQuicConfiguration;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.restlet.Server;
import org.restlet.data.Protocol;
import org.restlet.engine.connector.JettyServerHelper;
import org.restlet.engine.security.RestletSslContextFactoryServer;
import org.restlet.engine.ssl.SslUtils;

public class HttpsServerHelper
extends JettyServerHelper {
    public HttpsServerHelper(Server server) {
        super(server);
        this.getProtocols().add(Protocol.HTTPS);
    }

    @Override
    protected List<Connector> createConnectors(org.eclipse.jetty.server.Server server) {
        ArrayList<Connector> result = new ArrayList<Connector>();
        List<HttpTransportProtocol> httpTransportProtocols = this.getHttpTransportProtocols().stream().map(HttpTransportProtocol::fromName).toList();
        if (httpTransportProtocols.stream().anyMatch(HttpTransportProtocol::isTcpProtocol)) {
            HttpConfiguration configuration = this.createHttpConfiguration();
            ServerConnector connector = this.createServerConnector(server, configuration);
            result.add((Connector)connector);
        } else if (httpTransportProtocols.contains((Object)HttpTransportProtocol.HTTP3)) {
            ServerQuicConfiguration configuration = this.createQuicConfiguration(this.getQuicServerSslContextFactory());
            QuicServerConnector connector = this.createQuicServerConnector(server, configuration);
            result.add((Connector)connector);
        }
        return result;
    }

    @Override
    protected ConnectionFactory[] createConnectionFactories(HttpConfiguration configuration) {
        ArrayList<HttpConnectionFactory> connectionFactories = new ArrayList<HttpConnectionFactory>();
        List<HttpTransportProtocol> tcpBasedTransportProtocols = this.getHttpTransportProtocols().stream().map(HttpTransportProtocol::fromName).filter(HttpTransportProtocol::isTcpProtocol).toList();
        for (HttpTransportProtocol tcpBasedTransportProtocol : tcpBasedTransportProtocols) {
            List<HttpConnectionFactory> protocolConnectionFactories = switch (tcpBasedTransportProtocol.ordinal()) {
                case 0 -> List.of(new HttpConnectionFactory(configuration));
                case 1 -> List.of(new ALPNServerConnectionFactory(new String[0]), new HTTP2ServerConnectionFactory(configuration));
                default -> {
                    String supportedHttpTransportProtocols = tcpBasedTransportProtocols.toString();
                    String errorMessage = String.format("'%s' is not one of the supported values: %s", new Object[]{tcpBasedTransportProtocol, supportedHttpTransportProtocols});
                    throw new IllegalArgumentException(errorMessage);
                }
            };
            connectionFactories.addAll(protocolConnectionFactories);
        }
        SslContextFactory.Server sslContextFactory = this.getServerSslContextFactory();
        return AbstractConnectionFactory.getFactories((SslContextFactory.Server)sslContextFactory, (ConnectionFactory[])connectionFactories.toArray(new ConnectionFactory[0]));
    }

    private QuicServerConnector createQuicServerConnector(org.eclipse.jetty.server.Server server, ServerQuicConfiguration configuration) {
        QuicServerConnector connector = new QuicServerConnector(server, configuration, new ConnectionFactory[]{new HTTP3ServerConnectionFactory(configuration)});
        String address = ((Server)this.getHelped()).getAddress();
        if (address != null) {
            connector.setHost(address);
        }
        connector.setPort(((Server)this.getHelped()).getPort());
        connector.setIdleTimeout((long)this.getConnectorIdleTimeout());
        connector.setShutdownIdleTimeout(this.getShutdownTimeout());
        return connector;
    }

    public List<String> getHttpTransportProtocols() {
        String httpTransportProtocolsAsString = this.getHelpedParameters().getFirstValue("http.transport.protocols", HttpTransportProtocol.HTTP1_1.name());
        return Arrays.stream(httpTransportProtocolsAsString.split(",")).map(String::trim).distinct().toList();
    }

    public String getHttp3PemWorkDir() {
        return this.getHelpedParameters().getFirstValue("http3.pem.workdir");
    }

    private Path getHttp3PemWorkDirectoryPath() {
        return Optional.ofNullable(this.getHttp3PemWorkDir()).map(x$0 -> Path.of(x$0, new String[0])).orElse(null);
    }

    private SslContextFactory.Server getServerSslContextFactory() {
        try {
            return new RestletSslContextFactoryServer(SslUtils.getSslContextFactory(this));
        }
        catch (RuntimeException e) {
            this.getLogger().log(Level.WARNING, "Unable to create the Jetty SSL context factory", e);
            throw e;
        }
        catch (Exception e) {
            this.getLogger().log(Level.WARNING, "Unable to create the Jetty SSL context factory", e);
            throw new RuntimeException(e);
        }
    }

    private SslContextFactory.Server getQuicServerSslContextFactory() {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePassword(this.getHelpedParameters().getFirstValue("keyStorePassword", true, System.getProperty("javax.net.ssl.keyStorePassword", "")));
        sslContextFactory.setKeyStorePath(this.getHelpedParameters().getFirstValue("keyStorePath", true, System.getProperty("javax.net.ssl.keyStore")));
        sslContextFactory.setKeyStoreType(this.getHelpedParameters().getFirstValue("keyStoreType", true, System.getProperty("javax.net.ssl.keyStoreType")));
        sslContextFactory.setProtocol(this.getHelpedParameters().getFirstValue("protocol", true, "TLS"));
        sslContextFactory.setSecureRandomAlgorithm(this.getHelpedParameters().getFirstValue("secureRandomAlgorithm", true));
        sslContextFactory.setTrustStorePassword(this.getHelpedParameters().getFirstValue("trustStorePassword", true, System.getProperty("javax.net.ssl.trustStorePassword")));
        sslContextFactory.setTrustStorePath(this.getHelpedParameters().getFirstValue("trustStorePath", true, System.getProperty("javax.net.ssl.trustStore")));
        sslContextFactory.setTrustStoreType(this.getHelpedParameters().getFirstValue("trustStoreType", true, System.getProperty("javax.net.ssl.trustStoreType")));
        return sslContextFactory;
    }

    private ServerQuicConfiguration createQuicConfiguration(SslContextFactory.Server sslContextFactory) {
        Path pemWorkDirectory = this.getHttp3PemWorkDirectoryPath();
        ServerQuicConfiguration configuration = new ServerQuicConfiguration(sslContextFactory, pemWorkDirectory);
        configuration.setOutputBufferSize(this.getHttpOutputBufferSize());
        return configuration;
    }

    private static enum HttpTransportProtocol {
        HTTP1_1(true),
        HTTP2(true),
        HTTP3(false);

        private final boolean tcpProtocol;

        static HttpTransportProtocol fromName(String name) {
            try {
                return HttpTransportProtocol.valueOf(name);
            }
            catch (IllegalArgumentException iae) {
                String supportedHttpTransportProtocols = Arrays.toString((Object[])HttpTransportProtocol.values());
                String errorMessage = String.format("'%s' is not one of the supported values: %s", name, supportedHttpTransportProtocols);
                throw new IllegalArgumentException(errorMessage);
            }
        }

        private HttpTransportProtocol(boolean tcpProtocol) {
            this.tcpProtocol = tcpProtocol;
        }

        public boolean isTcpProtocol() {
            return this.tcpProtocol;
        }
    }
}

