/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.revapi.gradle.AnalysisResult;
import org.revapi.gradle.ImmutableAnalysisResults;
import org.revapi.gradle.config.AcceptedBreak;
import org.revapi.gradle.config.Justification;

@JsonDeserialize(as=ImmutableAnalysisResults.class)
@Value.Immutable
public abstract class AnalysisResults {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().enable(new JsonParser.Feature[]{JsonReadFeature.ALLOW_TRAILING_COMMA.mappedFeature()});

    public abstract String archiveNames();

    public abstract List<AnalysisResult> results();

    final Set<AcceptedBreak> toAcceptedBreaks(Justification justification) {
        return this.results().stream().map(result -> result.toAcceptedBreak(justification)).collect(Collectors.toSet());
    }

    public static AnalysisResults fromFile(File file) {
        try {
            return (AnalysisResults)OBJECT_MAPPER.readValue(file, AnalysisResults.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    static class Builder
    extends ImmutableAnalysisResults.Builder {
        Builder() {
        }
    }
}

