/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import java.io.Reader;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jboss.dmr.ModelNode;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.DifferenceTransform;
import org.revapi.java.spi.JavaElement;

public final class CheckWhitelist
implements DifferenceTransform<JavaElement> {
    public static final String EXTENSION_ID = "gradle-revapi.check.whitelist";
    private static final Pattern[] EVERYTHING = new Pattern[]{Pattern.compile(".*")};
    private boolean enabled = false;
    private Set<String> whitelistedChecks;

    public void initialize(@Nonnull AnalysisContext analysisContext) {
        this.enabled = analysisContext.getConfiguration().isDefined();
        if (!this.enabled) {
            return;
        }
        this.whitelistedChecks = analysisContext.getConfiguration().asList().stream().map(ModelNode::asString).collect(Collectors.toSet());
    }

    public String getExtensionId() {
        return EXTENSION_ID;
    }

    @Nonnull
    public Pattern[] getDifferenceCodePatterns() {
        return EVERYTHING;
    }

    @Nullable
    public Difference transform(@Nullable JavaElement _oldElement, @Nullable JavaElement _newElement, @Nonnull Difference difference) {
        if (!this.enabled) {
            return difference;
        }
        if (this.whitelistedChecks.contains(difference.code)) {
            return difference;
        }
        return null;
    }

    @Nullable
    public Reader getJSONSchema() {
        return null;
    }

    public void close() {
    }
}

