/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Optional;
import org.gradle.api.Project;
import org.revapi.gradle.RevapiConfig;

final class ConjureProjectFilters {
    private static final ArrayNode CHECKS_FOR_CLIENT_PROJECTS = RevapiConfig.createArrayNode().add("java.class.removed").add("java.method.removed").add("java.method.parameterTypeChanged");
    private static final ArrayNode SKIP_ALL_CHECKS = RevapiConfig.createArrayNode();

    private ConjureProjectFilters() {
    }

    public static RevapiConfig forProject(Project project) {
        boolean isConjure = Optional.ofNullable(project.getParent()).map(parentProject -> parentProject.getPluginManager().hasPlugin("com.palantir.conjure")).orElse(false);
        if (!isConjure) {
            return RevapiConfig.empty();
        }
        return ConjureProjectFilters.checksForProjectName(project.getName()).map(checks -> RevapiConfig.empty().withExtension("gradle-revapi.check.whitelist", (JsonNode)checks)).orElseGet(RevapiConfig::empty);
    }

    private static Optional<ArrayNode> checksForProjectName(String projectName) {
        if (projectName.endsWith("-jersey") || projectName.endsWith("-retrofit")) {
            return Optional.of(CHECKS_FOR_CLIENT_PROJECTS);
        }
        if (projectName.endsWith("-undertow")) {
            return Optional.of(SKIP_ALL_CHECKS);
        }
        return Optional.empty();
    }
}

