/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.gradle.api.Project;
import org.gradle.process.ExecResult;
import org.immutables.value.Value;
import org.revapi.gradle.ImmutableGitResult;

final class GitVersionUtils {
    private GitVersionUtils() {
    }

    public static Stream<String> previousGitTags(Project project) {
        return StreamSupport.stream(new PreviousGitTags(project), false).filter(tag -> !GitVersionUtils.isInitial000Tag(project, tag)).map(GitVersionUtils::stripVFromTag);
    }

    private static Optional<String> previousGitTagFromRef(Project project, String ref) {
        boolean thereIsNoCommitBeforeTheRef;
        String beforeLastRef = ref + "^";
        GitResult beforeLastRefTypeResult = GitVersionUtils.execute(project, "git", "cat-file", "-t", beforeLastRef);
        boolean bl = thereIsNoCommitBeforeTheRef = !beforeLastRefTypeResult.stdout().equals("commit");
        if (thereIsNoCommitBeforeTheRef) {
            return Optional.empty();
        }
        GitResult describeResult = GitVersionUtils.execute(project, "git", "describe", "--tags", "--abbrev=0", beforeLastRef);
        if (describeResult.stderr().contains("No tags can describe") || describeResult.stderr().contains("No names found, cannot describe anything")) {
            return Optional.empty();
        }
        return Optional.of(describeResult.stdoutOrThrowIfNonZero());
    }

    private static boolean isInitial000Tag(Project project, String tag) {
        if (!tag.equals("0.0.0")) {
            return false;
        }
        GitResult foo = GitVersionUtils.execute(project, "git", "rev-parse", "--verify", "--quiet", "0.0.0^");
        boolean parentDoesNotExist = foo.exitCode() != 0;
        return parentDoesNotExist;
    }

    private static String stripVFromTag(String tag) {
        if (tag.startsWith("v")) {
            return tag.substring(1);
        }
        return tag;
    }

    private static GitResult execute(Project project, String ... command) {
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        ExecResult execResult = project.exec(spec -> {
            spec.setCommandLine(Arrays.asList(command));
            spec.setStandardOutput((OutputStream)stdout);
            spec.setErrorOutput((OutputStream)stderr);
            spec.setIgnoreExitValue(true);
        });
        return GitResult.builder().exitCode(execResult.getExitValue()).stdout(new String(stdout.toByteArray(), StandardCharsets.UTF_8).trim()).stderr(new String(stderr.toByteArray(), StandardCharsets.UTF_8).trim()).build();
    }

    private static final class PreviousGitTags
    implements Spliterator<String> {
        private final Project project;
        private String lastSeenRef = "HEAD";

        PreviousGitTags(Project project) {
            this.project = project;
        }

        @Override
        public boolean tryAdvance(Consumer<? super String> action) {
            Optional tag = GitVersionUtils.previousGitTagFromRef(this.project, this.lastSeenRef);
            if (!tag.isPresent()) {
                return false;
            }
            this.lastSeenRef = (String)tag.get();
            action.accept(this.lastSeenRef);
            return true;
        }

        @Override
        public Spliterator<String> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 0;
        }
    }

    @Value.Immutable
    static interface GitResult {
        public int exitCode();

        public String stdout();

        public String stderr();

        public List<String> command();

        default public String stdoutOrThrowIfNonZero() {
            if (this.exitCode() == 0) {
                return this.stdout();
            }
            throw new RuntimeException("Failed running command:\n\tCommand:" + this.command() + "\n\tExit code: " + this.exitCode() + "\n\tStdout:" + this.stdout() + "\n\tStderr:" + this.stderr() + "\n");
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends ImmutableGitResult.Builder {
        }
    }
}

