/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.revapi.CompatibilityType;
import org.revapi.DifferenceSeverity;
import org.revapi.gradle.AnalysisResult;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AnalysisResult", generator="Immutables")
@Immutable
final class ImmutableAnalysisResult
extends AnalysisResult {
    private final String code;
    @Nullable
    private final String oldElement;
    @Nullable
    private final String newElement;
    @Nullable
    private final String description;
    @Nullable
    private final String oldArchiveName;
    @Nullable
    private final String newArchiveName;
    private final Map<CompatibilityType, DifferenceSeverity> classification;

    private ImmutableAnalysisResult(String code, @Nullable String oldElement, @Nullable String newElement, @Nullable String description, @Nullable String oldArchiveName, @Nullable String newArchiveName, Map<CompatibilityType, DifferenceSeverity> classification) {
        this.code = code;
        this.oldElement = oldElement;
        this.newElement = newElement;
        this.description = description;
        this.oldArchiveName = oldArchiveName;
        this.newArchiveName = newArchiveName;
        this.classification = classification;
    }

    @Override
    @JsonProperty(value="code")
    public String code() {
        return this.code;
    }

    @Override
    @JsonProperty(value="oldElement")
    @Nullable
    public String oldElement() {
        return this.oldElement;
    }

    @Override
    @JsonProperty(value="newElement")
    @Nullable
    public String newElement() {
        return this.newElement;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="oldArchiveName")
    @Nullable
    public String oldArchiveName() {
        return this.oldArchiveName;
    }

    @Override
    @JsonProperty(value="newArchiveName")
    @Nullable
    public String newArchiveName() {
        return this.newArchiveName;
    }

    @Override
    @JsonProperty(value="classification")
    public Map<CompatibilityType, DifferenceSeverity> classification() {
        return this.classification;
    }

    public final ImmutableAnalysisResult withCode(String value) {
        String newValue = Objects.requireNonNull(value, "code");
        if (this.code.equals(newValue)) {
            return this;
        }
        return new ImmutableAnalysisResult(newValue, this.oldElement, this.newElement, this.description, this.oldArchiveName, this.newArchiveName, this.classification);
    }

    public final ImmutableAnalysisResult withOldElement(@Nullable String value) {
        if (Objects.equals(this.oldElement, value)) {
            return this;
        }
        return new ImmutableAnalysisResult(this.code, value, this.newElement, this.description, this.oldArchiveName, this.newArchiveName, this.classification);
    }

    public final ImmutableAnalysisResult withNewElement(@Nullable String value) {
        if (Objects.equals(this.newElement, value)) {
            return this;
        }
        return new ImmutableAnalysisResult(this.code, this.oldElement, value, this.description, this.oldArchiveName, this.newArchiveName, this.classification);
    }

    public final ImmutableAnalysisResult withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableAnalysisResult(this.code, this.oldElement, this.newElement, value, this.oldArchiveName, this.newArchiveName, this.classification);
    }

    public final ImmutableAnalysisResult withOldArchiveName(@Nullable String value) {
        if (Objects.equals(this.oldArchiveName, value)) {
            return this;
        }
        return new ImmutableAnalysisResult(this.code, this.oldElement, this.newElement, this.description, value, this.newArchiveName, this.classification);
    }

    public final ImmutableAnalysisResult withNewArchiveName(@Nullable String value) {
        if (Objects.equals(this.newArchiveName, value)) {
            return this;
        }
        return new ImmutableAnalysisResult(this.code, this.oldElement, this.newElement, this.description, this.oldArchiveName, value, this.classification);
    }

    public final ImmutableAnalysisResult withClassification(Map<CompatibilityType, ? extends DifferenceSeverity> entries) {
        if (this.classification == entries) {
            return this;
        }
        Map<CompatibilityType, DifferenceSeverity> newValue = ImmutableAnalysisResult.createUnmodifiableEnumMap(true, false, entries);
        return new ImmutableAnalysisResult(this.code, this.oldElement, this.newElement, this.description, this.oldArchiveName, this.newArchiveName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAnalysisResult && this.equalTo(0, (ImmutableAnalysisResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableAnalysisResult another) {
        return this.code.equals(another.code) && Objects.equals(this.oldElement, another.oldElement) && Objects.equals(this.newElement, another.newElement) && Objects.equals(this.description, another.description) && Objects.equals(this.oldArchiveName, another.oldArchiveName) && Objects.equals(this.newArchiveName, another.newArchiveName) && this.classification.equals(another.classification);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.code.hashCode();
        h += (h << 5) + Objects.hashCode(this.oldElement);
        h += (h << 5) + Objects.hashCode(this.newElement);
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.oldArchiveName);
        h += (h << 5) + Objects.hashCode(this.newArchiveName);
        h += (h << 5) + this.classification.hashCode();
        return h;
    }

    public String toString() {
        return "AnalysisResult{code=" + this.code + ", oldElement=" + this.oldElement + ", newElement=" + this.newElement + ", description=" + this.description + ", oldArchiveName=" + this.oldArchiveName + ", newArchiveName=" + this.newArchiveName + ", classification=" + this.classification + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAnalysisResult fromJson(Json json) {
        AnalysisResult.Builder builder = new AnalysisResult.Builder();
        if (json.code != null) {
            builder.code(json.code);
        }
        if (json.oldElement != null) {
            builder.oldElement(json.oldElement);
        }
        if (json.newElement != null) {
            builder.newElement(json.newElement);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.oldArchiveName != null) {
            builder.oldArchiveName(json.oldArchiveName);
        }
        if (json.newArchiveName != null) {
            builder.newArchiveName(json.newArchiveName);
        }
        if (json.classification != null) {
            builder.putAllClassification(json.classification);
        }
        return (ImmutableAnalysisResult)builder.build();
    }

    public static AnalysisResult copyOf(AnalysisResult instance) {
        if (instance instanceof ImmutableAnalysisResult) {
            return (ImmutableAnalysisResult)instance;
        }
        return new AnalysisResult.Builder().from(instance).build();
    }

    private static <K extends Enum<K>, V> Map<K, V> createUnmodifiableEnumMap(boolean checkNulls, boolean skipNulls, Map<K, ? extends V> map) {
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        EnumMap<K, ? extends V> enumMap = new EnumMap<K, V>(map);
        if (checkNulls || skipNulls) {
            Iterator<V> it = map.values().iterator();
            while (it.hasNext()) {
                V v = it.next();
                if (checkNulls) {
                    Objects.requireNonNull(v, "value");
                    continue;
                }
                if (!skipNulls || v != null) continue;
                it.remove();
            }
        }
        return Collections.unmodifiableMap(enumMap);
    }

    @Generated(from="AnalysisResult", generator="Immutables")
    @NotThreadSafe
    static class Builder {
        private static final long INIT_BIT_CODE = 1L;
        private long initBits = 1L;
        @Nullable
        private String code;
        @Nullable
        private String oldElement;
        @Nullable
        private String newElement;
        @Nullable
        private String description;
        @Nullable
        private String oldArchiveName;
        @Nullable
        private String newArchiveName;
        private EnumMap<CompatibilityType, DifferenceSeverity> classification = new EnumMap(CompatibilityType.class);

        Builder() {
            if (!(this instanceof AnalysisResult.Builder)) {
                throw new UnsupportedOperationException("Use: new AnalysisResult.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final AnalysisResult.Builder from(AnalysisResult instance) {
            String newArchiveNameValue;
            String oldArchiveNameValue;
            String descriptionValue;
            String newElementValue;
            Objects.requireNonNull(instance, "instance");
            this.code(instance.code());
            String oldElementValue = instance.oldElement();
            if (oldElementValue != null) {
                this.oldElement(oldElementValue);
            }
            if ((newElementValue = instance.newElement()) != null) {
                this.newElement(newElementValue);
            }
            if ((descriptionValue = instance.description()) != null) {
                this.description(descriptionValue);
            }
            if ((oldArchiveNameValue = instance.oldArchiveName()) != null) {
                this.oldArchiveName(oldArchiveNameValue);
            }
            if ((newArchiveNameValue = instance.newArchiveName()) != null) {
                this.newArchiveName(newArchiveNameValue);
            }
            this.putAllClassification(instance.classification());
            return (AnalysisResult.Builder)this;
        }

        @JsonProperty(value="code")
        @CanIgnoreReturnValue
        public final AnalysisResult.Builder code(String code) {
            this.code = Objects.requireNonNull(code, "code");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (AnalysisResult.Builder)this;
        }

        @JsonProperty(value="oldElement")
        @CanIgnoreReturnValue
        public final AnalysisResult.Builder oldElement(@Nullable String oldElement) {
            this.oldElement = oldElement;
            return (AnalysisResult.Builder)this;
        }

        @JsonProperty(value="newElement")
        @CanIgnoreReturnValue
        public final AnalysisResult.Builder newElement(@Nullable String newElement) {
            this.newElement = newElement;
            return (AnalysisResult.Builder)this;
        }

        @JsonProperty(value="description")
        @CanIgnoreReturnValue
        public final AnalysisResult.Builder description(@Nullable String description) {
            this.description = description;
            return (AnalysisResult.Builder)this;
        }

        @JsonProperty(value="oldArchiveName")
        @CanIgnoreReturnValue
        public final AnalysisResult.Builder oldArchiveName(@Nullable String oldArchiveName) {
            this.oldArchiveName = oldArchiveName;
            return (AnalysisResult.Builder)this;
        }

        @JsonProperty(value="newArchiveName")
        @CanIgnoreReturnValue
        public final AnalysisResult.Builder newArchiveName(@Nullable String newArchiveName) {
            this.newArchiveName = newArchiveName;
            return (AnalysisResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final AnalysisResult.Builder putClassification(CompatibilityType key, DifferenceSeverity value) {
            this.classification.put(Objects.requireNonNull(key, "classification key"), Objects.requireNonNull(value, value == null ? "classification value for key: " + key : null));
            return (AnalysisResult.Builder)this;
        }

        @CanIgnoreReturnValue
        public final AnalysisResult.Builder putClassification(Map.Entry<CompatibilityType, ? extends DifferenceSeverity> entry) {
            DifferenceSeverity v;
            CompatibilityType k = entry.getKey();
            this.classification.put(Objects.requireNonNull(k, "classification key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "classification value for key: " + k : null));
            return (AnalysisResult.Builder)this;
        }

        @JsonProperty(value="classification")
        @CanIgnoreReturnValue
        public final AnalysisResult.Builder classification(Map<CompatibilityType, ? extends DifferenceSeverity> entries) {
            this.classification.clear();
            return this.putAllClassification(entries);
        }

        @CanIgnoreReturnValue
        public final AnalysisResult.Builder putAllClassification(Map<CompatibilityType, ? extends DifferenceSeverity> entries) {
            for (Map.Entry<CompatibilityType, ? extends DifferenceSeverity> e : entries.entrySet()) {
                DifferenceSeverity v;
                CompatibilityType k = e.getKey();
                this.classification.put(Objects.requireNonNull(k, "classification key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "classification value for key: " + k : null));
            }
            return (AnalysisResult.Builder)this;
        }

        public AnalysisResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAnalysisResult(this.code, this.oldElement, this.newElement, this.description, this.oldArchiveName, this.newArchiveName, ImmutableAnalysisResult.createUnmodifiableEnumMap(false, false, this.classification));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("code");
            }
            return "Cannot build AnalysisResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AnalysisResult", generator="Immutables")
    static final class Json
    extends AnalysisResult {
        @Nullable
        String code;
        @Nullable
        String oldElement;
        @Nullable
        String newElement;
        @Nullable
        String description;
        @Nullable
        String oldArchiveName;
        @Nullable
        String newArchiveName;
        @Nullable
        Map<CompatibilityType, DifferenceSeverity> classification = Collections.emptyMap();

        Json() {
        }

        @JsonProperty(value="code")
        public void setCode(String code) {
            this.code = code;
        }

        @JsonProperty(value="oldElement")
        public void setOldElement(@Nullable String oldElement) {
            this.oldElement = oldElement;
        }

        @JsonProperty(value="newElement")
        public void setNewElement(@Nullable String newElement) {
            this.newElement = newElement;
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="oldArchiveName")
        public void setOldArchiveName(@Nullable String oldArchiveName) {
            this.oldArchiveName = oldArchiveName;
        }

        @JsonProperty(value="newArchiveName")
        public void setNewArchiveName(@Nullable String newArchiveName) {
            this.newArchiveName = newArchiveName;
        }

        @JsonProperty(value="classification")
        public void setClassification(Map<CompatibilityType, DifferenceSeverity> classification) {
            this.classification = classification;
        }

        @Override
        public String code() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String oldElement() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String newElement() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String oldArchiveName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String newArchiveName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<CompatibilityType, DifferenceSeverity> classification() {
            throw new UnsupportedOperationException();
        }
    }
}

