/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.gradle;

import java.io.Reader;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.DifferenceTransform;
import org.revapi.gradle.RevapiConfig;
import org.revapi.java.model.MethodElement;
import org.revapi.java.spi.Code;
import org.revapi.java.spi.JavaElement;

public final class ImmutablesFilter
implements DifferenceTransform<JavaElement> {
    private static final String EXTENSION_ID = "gradle-revapi.immutables";
    public static final RevapiConfig CONFIG = RevapiConfig.empty().withExtension("gradle-revapi.immutables");
    private static final Pattern[] DIFFERENCE_CODE_PATTERNS = (Pattern[])Stream.of(Code.METHOD_ABSTRACT_METHOD_ADDED, Code.METHOD_RETURN_TYPE_CHANGED, Code.METHOD_VISIBILITY_REDUCED, Code.METHOD_NOW_ABSTRACT, Code.METHOD_REMOVED).map(Code::code).map(Pattern::compile).toArray(Pattern[]::new);

    public String getExtensionId() {
        return EXTENSION_ID;
    }

    @Nonnull
    public Pattern[] getDifferenceCodePatterns() {
        return DIFFERENCE_CODE_PATTERNS;
    }

    public void initialize(@Nonnull AnalysisContext _analysisContext) {
    }

    @Nullable
    public Difference transform(@Nullable JavaElement oldElement, @Nullable JavaElement newElement, @Nonnull Difference difference) {
        if (ImmutablesFilter.shouldIgnore(oldElement, newElement, difference)) {
            return null;
        }
        return difference;
    }

    private static boolean shouldIgnore(@Nullable JavaElement oldElement, @Nullable JavaElement newElement, @Nonnull Difference difference) {
        switch (Code.fromCode((String)difference.code)) {
            case METHOD_ABSTRACT_METHOD_ADDED: {
                return ImmutablesFilter.inImmutablesClass(newElement);
            }
            case METHOD_RETURN_TYPE_CHANGED: 
            case METHOD_VISIBILITY_REDUCED: {
                return ImmutablesFilter.inImmutablesClass(oldElement) && ImmutablesFilter.inImmutablesClass(newElement) && ImmutablesFilter.abstractNonPublic(oldElement);
            }
            case METHOD_REMOVED: {
                return ImmutablesFilter.inImmutablesClass(oldElement) && ImmutablesFilter.abstractNonPublic(oldElement);
            }
            case METHOD_NOW_ABSTRACT: {
                return ImmutablesFilter.inImmutablesClass(oldElement) && ImmutablesFilter.inImmutablesClass(newElement);
            }
        }
        return false;
    }

    private static boolean inImmutablesClass(JavaElement javaElement) {
        return ImmutablesFilter.methodElementFor(javaElement).map(methodElement -> ((ExecutableElement)methodElement.getDeclaringElement()).getEnclosingElement().getAnnotationMirrors().stream().anyMatch(annotationMirror -> annotationMirror.toString().equals("@org.immutables.value.Value.Immutable"))).orElse(false);
    }

    private static Optional<MethodElement> methodElementFor(JavaElement javaElement) {
        if (javaElement == null) {
            return Optional.empty();
        }
        if (!(javaElement instanceof MethodElement)) {
            return Optional.empty();
        }
        return Optional.of((MethodElement)javaElement);
    }

    private static boolean abstractNonPublic(JavaElement javaElement) {
        return ImmutablesFilter.methodElementFor(javaElement).map(methodElement -> {
            Set<Modifier> modifiers = ((ExecutableElement)methodElement.getDeclaringElement()).getModifiers();
            return modifiers.contains((Object)Modifier.ABSTRACT) && !modifiers.contains((Object)Modifier.PUBLIC);
        }).orElse(false);
    }

    @Nullable
    public Reader getJSONSchema() {
        return null;
    }

    public void close() {
    }
}

